/* $Id: bench_sock.c,v 1.1.1.1 1998/12/02 16:51:38 roca Exp $ */
/*
 * bench_sock.c
 *
 *	Modified by : V.Roca
 *	Date	    : dec 1997
 *
 *	Client part of the performance evaluation tool.
 *	Socket access method routines.
 */
/*
 * (c) Copyright 1998 - V. Roca: this tool is provided as is, without
 * any warranty.
 * Permission to use, copy and modify is provided for non commercial
 * purposes as long as this notice appears on all copies.
 */

#include "bench.h"
#include "bench_proto.h"


void
SockOpen (int	num)
{
	struct hostent *h;

	ASSERT(sock)
	if ((h = gethostbyname(rname)) == NULL) {
		PRINT_OUT((stdout, "bench: don't know remotename ""%s""\n", rname))
		EXIT(num, 1);
	}

	memset((char *)&sa, 0, sizeof(sa));
	memcpy((char *)&sa.sin_addr.s_addr, h->h_addr_list[0], h->h_length);
	sa.sin_family = AF_INET;
	if (eport)
		sa.sin_port = htons(atoi(myport));
	else {
		struct servent *sp;

		if (!(sp = getservbyname(servername, "tcp"))) {
			PRINT_OUT((stdout, "bench: don't know server name ""%s""\n", servername))
			EXIT(num, 1);
		}
		sa.sin_port = htons(sp->s_port);
	}

	if (tcp) {
		if ((conn_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
			perror("bench: socket");
			EXIT(num, 1);
		}
		if (nodelay) {
			int on = 1;
			if (setsockopt(conn_fd, IPPROTO_TCP, TCP_NODELAY,
				       (char*)&on, sizeof(on)) < 0) {
				perror("bench: SetNodelayOption");
				EXIT(num, 1);
			}
		}
		if (connect(conn_fd, (struct sockaddr*)&sa, sizeof(sa)) < 0) {
			perror("bench: connect");
			PRINT_ERR((stderr,
				"bench: check that server %s/%d is up\n",
				inet_ntoa(sa.sin_addr), sa.sin_port))
			EXIT(num, 1);
		}
	} else {	/* udp */
		if ((conn_fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
			perror("bench udp/bcast/mcast: socket");
			EXIT(num, 1);
		}

		if (bcast) {
			unsigned long t_net_type;
			int on = 1;

			if (setsockopt(conn_fd, SOL_SOCKET, SO_BROADCAST,
				       (char*)&on, sizeof(on)) < 0) {
				perror("bench bcast: setsockopt SO_BROADCAST");
				EXIT(num, 1);
			}
			t_net_type = (unsigned long)sa.sin_addr.s_addr;
			t_net_type = (t_net_type >> 24);
			if (t_net_type >= 0 && t_net_type <= 126)
				sa.sin_addr = inet_makeaddr(inet_netof(sa.sin_addr), 0x00ffffff);
			else if (t_net_type >= 128 && t_net_type <= 191)
				sa.sin_addr = inet_makeaddr(inet_netof(sa.sin_addr), 0x0000ffff);
			else if (t_net_type >= 192 && t_net_type <= 223)
				sa.sin_addr = inet_makeaddr(inet_netof(sa.sin_addr), 0x000000ff);
			else {
				PRINT_ERR((stderr, "bench: bad network type\n"))
				EXIT(num, 1);
			}
			PRINT_OUT((stdout, "CLIENT bcast addr:\t%s\n",
				   inet_ntoa(sa.sin_addr)))
		} else if (mcast) {
		}
	}
}


/*
 *	This is here that messages are sent if the socket API is used!
 */
void
SockSendMsg (int	num)
{
	int	i;
	int	sdata;
	int	rdata;
	u_short	udp_count = 0;	/* UDP packet counter */
	/* int	error = 0; */	/* used for the various snd_version cases */
	int	res;		/* return value of select or poll */
	int	pkt = 0;	/* nb of packets already sent in a burst */

	signal (SIGINT, (sighandler_t)Interrupted);
	
#ifdef FAST_SYNC
	if (udp) {
		/*
		 * Inform the server immediately of the start of the UDP test.
		 * Not required with TCP since in that case opening of the
		 * connection is enough (and as efficient!).
		 */
		if ((sdata = sendto(conn_fd, START_MSG, START_STOP_MSG_SIZE, 0, (struct sockaddr*)&sa, sizeof(sa))) < 0) {
			perror("bench udp/bcast: sendto");
			exit(1);
		}
	}
#endif /* FAST_SYNC */

	gettimeofday(&time0, NULL);
	time1 = time0;
	for (i = 0 ; duration > 0 || nbmsg < 0 || i < nbmsg ; i++) {
		/*
		 * In case of rate control, wait a little bit
		 * between two bursts...
		 */
		if (rate) {
			if (pkt >= pkts_in_burst) {
				usleep(rate_interval);
				pkt = 0;
			}
			pkt++;
		}
#ifdef MTRACE
		/*
		 * Do not start immediately. Wait a while to be sure
		 * the working set is in memory and tcp in normal data
		 * transfer.
		 */
#define MTR_START	200
#define MTR_STOP	200
		if (mtrace && i == MTR_START)
			mtraceon();
#endif /* MTRACE */
		if (udp) {
			/* UDP packet numerotation */
			if (lgthmsg >= sizeof(u_short))
				*(u_short*)sndbuf = udp_count++;
			errno = 0;
			if (mode == TT_MODE &&
			    lgthmsg >= sizeof(u_short) + sizeof(struct timeval)) {
				/*
				 * need a timestamp; store
				 * it after the UDP packet count
				 */
				gettimeofday((struct timeval*)(sndbuf + sizeof(u_short)), NULL);
			}
			if ((sdata = sendto(conn_fd, sndbuf, lgthmsg, 0, (struct sockaddr*)&sa, sizeof(sa))) < 0) {
				if (errno == ENOBUFS) {
					PRINT_ERR((stderr, "bench: sendto: ENOBUFS\n"))
				} else {
					perror("bench udp/bcast: sendto");
					exit(1);
				}
				continue;
			}
		} else if (tcp) {
			if ((sdata = send(conn_fd, sndbuf, lgthmsg, 0)) < 0) {
				perror("bench: send");
				EXIT(num, 1);
			}
		}
		if (sdata != lgthmsg)
			PRINT_ERR((stderr,"bench: %d bytes sent instead of %d\n",
				sdata, lgthmsg))
#ifdef BOSX41
		CCA_TRCHKL1T(CCA_USER_HKWD | bench_snd_end, sdata);
#endif

		if (mode == RTT_MODE) {
			int	remains;
			/*
			 * After each send, make sure we receive the same
			 * amount of data. Do several recv if necessary.
			 */
			for (remains = sdata ; remains > 0 ; remains -= rdata) {
				if (udp) {
					int	fromlen = sizeof(sa);
					/*
					 * First need to be sure we
					 * won't wait for too long if
					 * an UDP packet has been lost.
					 * Wait at most 1 second.
					 */
					if ((res = SockSelect(conn_fd, 1, 0)) == 0) {
						perror("bench: timeout, udp packet lost");
						/* dont take lost packet
						 * into account for stats */
						gettimeofday(&time1, NULL);
						goto next_iteration;
					}
					if ((rdata = recvfrom(conn_fd, sndbuf, remains, 0, (struct sockaddr*)&sa, &fromlen)) < 0) {
						perror("bench: recvfrom");
						EXIT(num, 1);
					}
				} else {
					if ((rdata = recv(conn_fd, sndbuf, remains, 0)) < 0) {
						perror("bench: recv");
						EXIT(num, 1);
					}
				}
#ifdef BOSX41
				CCA_TRCHKL1T(CCA_USER_HKWD | bench_rcv_end,
					     rdata);
#endif
			}
			/*
			 * In rtt mode, do not take received
			 * data into account for the statistics. It
			 * yields erroneous results.
			 */
		}
#ifdef MTRACE
		/*
		 * Now stop.
		 */
		if (mtrace && i == MTR_STOP)
			mtraceoff();
#endif /* MTRACE */
		/*
		 * Limit the time of each test to "duration" seconds.
		 */
		gettimeofday(&time2, NULL);
		if (duration > 0) {
			/*
			 * This is a rough estimate since we should also
			 * take usec into account ! Faster like that.
			 * Add 1 second to compensate ;-)
			 */
			if (time2.tv_sec >= time0.tv_sec + duration + 1) {
				goto end_test;
			}
		}
		Stats(num, sdata, 1, 0.0);
next_iteration:
		;
	}

end_test:
	/* Take the last packet sent into account (otherwise done in Debit) */
	recdata += sdata;
	recmsg++ ;
#ifdef FAST_SYNC
	if (udp) {
		/*
		 * Inform the server immediately of the end of the UDP test.
		 * Send several messages in case one of them is lost !!!
		 * (XXX: creates other pbs => avoid !)
		 * Not required with TCP since in that case closing the
		 * connection is enough (and as efficient!).
		 */
		for (i=0; i< 1; i++) {
			if ((sdata = sendto(conn_fd, STOP_MSG, START_STOP_MSG_SIZE, 0, (struct sockaddr*)&sa, sizeof(sa))) < 0) {
				/* previous STOP_MSG has probably arrived */
				break;
			}
		}
	}
#endif /* FAST_SYNC */
	EndStats();
}


/*
 * SockSelect
 *
 * Wait at most timeout for an event to arrive.
 *	- with Socket API, use select,
 *	- with XTI API, use poll.
 */
int
SockSelect (int	fd,
	    int	sec,
	    int	usec)
{
	int		res;
	fd_set		readmask;
	struct timeval	timeout;

	ASSERT(sock)

	FD_ZERO(&readmask);
	FD_SET(fd, &readmask);
	timeout.tv_sec = sec;
	timeout.tv_usec = usec;
	/* Warning: 1st param must be fd+1, not 1! */
	if ((res = select(fd + 1, &readmask, (fd_set *)0, (fd_set *)0,
			  &timeout)) < 0) {
		perror("bench: select failed");
		EXIT(0, 1);
	}
	return(res);
}


