/* $Id: bench_xti.c,v 1.1.1.1 1998/12/02 16:51:38 roca Exp $ */
/*
 * bench_xti.c
 *
 *	Modified by : V.Roca
 *	Date	    : dec 1997
 *
 *	Client part of the performance evaluation tool.
 *	XTI (X/Open Transport Interface) access method routines.
 */
/*
 * (c) Copyright 1998 - V. Roca: this tool is provided as is, without
 * any warranty.
 * Permission to use, copy and modify is provided for non commercial
 * purposes as long as this notice appears on all copies.
 */

#ifdef XTI	/* { */

#include "bench.h"




extern int xti, socket, tcp, udp, bcast, interactive, eport, tmsg;
#ifdef ETNA
extern int BSD_stack, STD_stack;
extern int rt_pri;
extern int pin;
extern int snd_version;
extern int rcv_version;
extern int duration;
extern int rate;
extern int rate_interval;
extern int dtonly;
extern int nodelay;
extern int push;
extern int mtrace;
extern int syncf;
extern int cpustat;
extern int lockstat;
extern int silent;
#endif /* ETNA */
extern int connex, conn_fd;
extern int recdata, recmsg, totdata, totmsg;
extern float fthrumin, fthrumax;
extern char servername[], myport[];
extern char provider[];
extern struct timeval time0, time1, time2;
extern struct xtitp tp;
extern struct sockaddr_in sa;
extern struct t_call *call;
extern struct t_unitdata *ud;
extern struct t_uderr *uderr;

static char remotename[MAX_NAME_LEN] = "localhost";
static char *sndbuf;
static struct t_bind *bindret;
static struct t_info xti_info;
static int nbmsg = -1, lgthmsg = DEF_DATA_SIZE, tpdusize = DEF_TPDU_SIZE, tpdu = 0;
static int classnb, class = 0;
static int con = 0, nbconn = 1;
static int delay = 0;
static int dead = 0;
static pid_t tab_pid[MAX_CONNECT];
static int flag_on;
#ifdef ETNA
static int sync_fd;			/* fd to the synchronization conn */
#endif /* ETNA */



STATIC void
Open (int	num)
{
	struct t_call *sndcall, *rcvcall;
	struct t_discon discon;

	if (xti) {
		struct netbuf *addr;

		if ((conn_fd = t_open(tp.tp_name, O_RDWR, &xti_info)) < 0) {
			t_error("bench: t_open failed for conn_fd");
			EXIT(num, 1);
		}

		if (udp && lgthmsg > xti_info.tsdu)
			Usage(1, "bench", xti_info.tsdu);

		if (udp) {
			if ((ud = (struct t_unitdata *)(t_alloc(conn_fd, T_UNITDATA_STR,
			                                        T_ADDR))) == NULL) {
				t_error("bench: t_alloc failed for t_unitdata struct");
				EXIT(num, 1);
			}
			ud->udata.len = lgthmsg;
			ud->udata.buf = sndbuf;
			addr = &ud->addr;

			if ((uderr = (struct t_uderr *)(t_alloc(conn_fd, T_UDERROR_STR,
			                                        T_ALL))) == NULL) {
				t_error("bench: t_alloc failed for t_uderr struct");
				EXIT(num, 1);
			}
		} else {
			if ((sndcall = (struct t_call *)(t_alloc(conn_fd, T_CALL_STR,
			                                         T_ALL))) == NULL) {
				t_error("bench: t_alloc failed for t_call struct");
				EXIT(num, 1);
			}
			addr = &sndcall->addr;
			if ((rcvcall = (struct t_call *)(t_alloc(conn_fd, T_CALL_STR,
			                                         T_ALL))) == NULL) {
				t_error("bench: t_alloc failed for t_call struct");
				EXIT(num, 1);
			}
		}
		
		if (eport) {
			struct sockaddr_in *sa;
			struct hostent *h;

			if ((h = gethostbyname(remotename)) == NULL) {
				PRINT_OUT((stdout, "bench: don't know remotename ""%s""\n",
				           remotename))
					EXIT(num, 1);
			}

			sa = (struct sockaddr_in *)addr->buf;
			sa->sin_family = AF_INET;
			memcpy((char *)&sa->sin_addr.s_addr, h->h_addr_list[0],
				h->h_length);
			sa->sin_port = atoi(myport);
			addr->len = sizeof(struct sockaddr_in);
		} else if (t_getraddr(&tp, remotename, servername, addr) < 0) {
			t_error_ns("bench: t_getraddr failed");
			EXIT(num, 1);
		}

		if (t_bind(conn_fd, NULL, NULL) < 0) {
			t_error("bench: t_bind failed for conn_fd");
			EXIT(num, 1);
		}

		if (!udp) {
#ifdef ETNA
			if (nodelay && SetNodelayOption(conn_fd) < 0) {
				t_error("bench: SetNodelayOption failed for conn_fd");
				EXIT(num, 1);
			}
#endif /* ETNA */
#ifndef TLI
			if (tpdu || class) {
				SetOptions(sndcall->opt.buf, tpdu, tpdusize, class, classnb);
				sndcall->opt.len = sizeof(struct isoco_options);
			}
#endif

			if (t_connect(conn_fd, sndcall, rcvcall) < 0) {
				t_error("bench: t_connect failed for conn_fd");
				if (t_errno == TLOOK) {
					if (t_rcvdis(conn_fd, &discon) < 0) {
						t_error("bench: t_rcvdis failed for conn_fd");
						EXIT(num, 1);
					}
					PRINT_ERR((stderr, "bench: T_DISCONNECT reason x%x\n", discon.reason))
				}
				EXIT(num, 1);
			}
		
#ifndef TLI
			if (tpdu || class)
				VerifOptions(rcvcall->opt.buf, tpdu, tpdusize, class, classnb);
#endif

			if (t_free((char *)sndcall, T_CALL_STR) < 0) {
				t_error("bench: t_free failed for sndcall");
				EXIT(num, 1);
			}
			if (t_free((char *)rcvcall, T_CALL_STR) < 0) {
				t_error("bench: t_free failed for rcvcall");
				EXIT(num, 1);
			}
		}
	} else {
		struct hostent *h;

		if ((h = gethostbyname(remotename)) == NULL) {
			PRINT_OUT((stdout, "bench: don't know remotename ""%s""\n", remotename))
			EXIT(num, 1);
		}

		memset((char *)&sa, 0, sizeof(sa));
		memcpy((char *)&sa.sin_addr.s_addr, h->h_addr_list[0],
			h->h_length);
		sa.sin_family = AF_INET;

		if (eport)
			sa.sin_port = atoi(myport);
		else {
			struct servent *sp;

			if (!(sp = getservbyname(servername, (tcp) ? "tcp" : "udp"))) {
				PRINT_OUT((stdout, "bench: don't know servername ""%s""\n", servername))
				EXIT(num, 1);
			}
			sa.sin_port = sp->s_port;
		}
	
		if (tcp) {
			if ((conn_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
				perror("bench tcp: socket");
				EXIT(num, 1);
			}

#ifdef ETNA
			if (nodelay && SetNodelayOption(conn_fd) < 0) {
				perror("bench tcp: SetNodelayOption");
				EXIT(num, 1);
			}
#endif /* ETNA */
			if (connect(conn_fd, &sa, sizeof(sa)) < 0) {
				perror("bench tcp: connect");
				EXIT(num, 1);
			}
		} else {
			if ((conn_fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
				perror("bench udp/bro: socket");
				EXIT(num, 1);
			}

			if (bro) {
				unsigned long t_net_type;
				int on = 1;

				if (setsockopt(conn_fd, SOL_SOCKET, SO_BROADCAST, &on,
                                               sizeof(on)) < 0) {
					perror("bench bro: setsockopt SO_BROADCAST");
					EXIT(num, 1);
				}
				t_net_type = (unsigned long)sa.sin_addr.s_addr;
				t_net_type = (t_net_type >> 24);
				if (t_net_type >= 0 && t_net_type <= 126)
					sa.sin_addr = inet_makeaddr(inet_netof(sa.sin_addr), 0x00ffffff);
				else if (t_net_type >= 128 && t_net_type <= 191)
					sa.sin_addr = inet_makeaddr(inet_netof(sa.sin_addr), 0x0000ffff);
				else if (t_net_type >= 192 && t_net_type <= 223)
					sa.sin_addr = inet_makeaddr(inet_netof(sa.sin_addr), 0x000000ff);
				else{
					PRINT_ERR((stderr, "bench: bad network type.\n" ))
					EXIT(num, 1);
				}
				PRINT_OUT((stdout, "CLIENT broad addr :\t%s\n", inet_ntoa(sa.sin_addr)))
			}
		}
	}
}

STATIC void
SendMsg (int	num)
{
	int i, sdata, rdata, msg, flags;
#ifdef ETNA
	int error = 0;		/* used for the various snd_version cases */
	int res;		/* return value of select or poll */
#endif /* ETNA */

#ifdef ETNA
	signal (SIGINT, Interrupted);	/* EndDebit no longer exits */
#else
	signal (SIGINT, EndDebit);
#endif
	
	gettimeofday(&time0, NULL);
	time1 = time0;
#ifdef ETNA
	for (i = 0 ; duration > 0 || nbmsg < 0 || i < nbmsg ; i++) {
#else
	for (i = 0 ; nbmsg < 0 || i < nbmsg ; i++) {
#endif
		/*
		 * In case of rate control, wait a little bit...
		 */
		if (rate)
			usleep(rate_interval);
#ifdef MTRACE
		/*
		 * Do not start immediately. Wait a while to be sure
		 * the working set is in memory and tcp in normal data
		 * transfer.
		 */
#define MTR_START	200
#define MTR_STOP	200
		if (mtrace && i == MTR_START)
			mtraceon();
#endif /* MTRACE */
		if (xti) {
			if (udp) {
				if ((t_sndudata(conn_fd, ud)) < 0) {
					t_error("bench: t_sndudata failed");
					if (t_errno == TLOOK) {
						/* error on previously sent datagram */
						if (t_rcvuderr(conn_fd, uderr) < 0) {
							t_error("bench: t_rcvuderr failed");
							EXIT(num, 1);
						}
	
						PRINT_ERR((stderr,"bench : error = %d\n", uderr->error))
						continue;
					}
					EXIT(num, 1);
				}
				sdata = lgthmsg;
			} else {
#ifdef ETNA
				switch (snd_version) {
				case 0:
					/*
					 * Standard t_snd()
					 */
					sdata = t_snd(conn_fd,sndbuf,lgthmsg,0);
					if (sdata < 0)
						error = 1;
					break;
				case 1:
					/*
					 * t_snd1() using write() internaly
					 */
					sdata = t_snd1(conn_fd,sndbuf,lgthmsg,0);
					if (sdata < 0)
						error = 1;
					break;
				case 2:
					/*
					 * Use write() directly
					 */
					sdata = write(conn_fd,sndbuf,lgthmsg);
					if (sdata < lgthmsg)
						error = 1;
					break;
				case 3:
					/*
					 * t_snd2() using putpmsg() w/o ctrl
					 * buf
					 */
					sdata = t_snd2(conn_fd,sndbuf,lgthmsg,
							0);
					if (sdata < 0)
						error = 1;
					break;
#ifdef ETNA_XTISEG
				case 4:
					/*
					 * t_sndseg() using putextmsg() w/o
					 * ctrl buf and w/o checksum
					 * Use T_MORE not to push data.
					 */
					sdata = t_sndseg(conn_fd,sndbuf,lgthmsg,
							push ? 0 : T_MORE);
					if (sdata < 0)
						error = 1;
					break;
				case 5:
					/*
					 * t_sndseg() using putextmsg() w/o
					 * ctrl buf and with checksum
					 * Use T_MORE not to push data.
					 */
					sdata = t_sndseg(conn_fd,sndbuf,lgthmsg,
							(push ? 0 : T_MORE) |
							T_COPYANDCKSUM);
					if (sdata < 0)
						error = 1;
					break;
#endif /* ETNA_XTISEG */
				}

				if (error) {
					if (t_errno == TLOOK) {
						PRINT_ERR((stderr, "bench: t_snd : connection aborted\n"))
						EXIT(num, 1);
					}
					t_error("bench: t_snd failed for conn_fd");
					EXIT(num, 1);
				}
#else  /* ETNA */
				if ((sdata = t_snd(conn_fd, sndbuf, lgthmsg, 0)) < 0) {
					if (t_errno == TLOOK) {
						PRINT_ERR((stderr, "bench: t_snd : connection aborted\n"))
						EXIT(num, 1);
					}
					t_error("bench: t_snd failed for conn_fd");
					EXIT(num, 1);
				}
#endif /* ETNA */
			}
		} else {
			if (udp) {
				errno = 0;
				if ((sdata = sendto(conn_fd, sndbuf, lgthmsg, 0, &sa, sizeof(sa))) < 0) {
					if (errno == ENOBUFS) {
						PRINT_ERR((stderr, "bench: sendto: ENOBUFS\n"))
					}
					if (sdata < 0 && errno != EINTR && errno != ENOBUFS)
						perror("bench udp/bro: sendto");
					continue;
				}
			} else {
				if ((sdata = send(conn_fd, sndbuf, lgthmsg, 0)) < 0) {
					perror("bench tcp: send");
					EXIT(num, 1);
				}
			}
		}
#ifdef ETNA
		if (sdata != lgthmsg)
			PRINT_ERR((stderr,"bench: %d bytes sent instead of %d\n",
				sdata, lgthmsg))
#endif /* ETNA */
		msg = 1;
		CCA_TRCHKL1T(CCA_USER_HKWD | bench_snd_end, sdata);
		if (interactive) {
#ifdef ETNA
			int	remains;
			/*
			 * After each send, make sure we receive
			 * the same amount of data. Do several
			 * recv if necessary.
			 */
			for (remains = sdata ; remains > 0 ; remains -= rdata) {
				if (xti) {
					if (udp) {
						t_error("bench: interactive mode with xti and udp not yet supported");
					} else {
						switch (rcv_version) {
						case 0:
							if ((rdata = t_rcv(conn_fd, sndbuf, remains, &flags)) < 0) {
								t_error("bench: t_rcv failed for conn_fd");
								EXIT(num, 1);
							}
							break;
						case 1:
							if ((rdata = t_rcv1(conn_fd, sndbuf, remains, &flags)) <= 0) {
								t_error("bench: t_rcv1 failed for conn_fd");
								close(conn_fd);
								EXIT(num, 1);
							}
							break;
						}
					}
				} else {
					if (udp) {
						int	fromlen = sizeof(sa);
						/*
						 * First need to be sure we
						 * won't wait for too long if
						 * an UDP packet has been lost.
						 * Wait at most 1 second.
						 */
						if ((res = poll_incoming_event(conn_fd, 1, 0)) == 0) {
							perror("bench: timeout, udp packet lost");
							/* dont take lost into
							 * account for stats */
							gettimeofday(&time1, NULL);
							goto next_iteration;
						}
						if ((rdata = recvfrom(conn_fd, sndbuf, remains, 0, &sa, &fromlen)) < 0) {
							perror("bench: recvfrom");
							EXIT(num, 1);
						}
					} else {
						if ((rdata = recv(conn_fd, sndbuf, remains, 0)) < 0) {
							perror("bench: recv");
							EXIT(num, 1);
						}
					}
				}
				CCA_TRCHKL1T(CCA_USER_HKWD | bench_rcv_end,
					     rdata);
			}
			/*
			 * In interactive mode, do not take received
			 * data into account for the statistics. It
			 * yields erroneous results.
			 */
#else  /* ETNA */
			if (xti) {
				if ((rdata = t_rcv(conn_fd, sndbuf, lgthmsg, &flags)) < 0) {
					t_error("bench: t_rcv failed for conn_fd");
					EXIT(num, 1);
				}
			}
			else {
				if ((rdata = recv(conn_fd, sndbuf, sdata, 0)) < 0) {
					perror("bench tcp: recv");
					EXIT(num, 1);
				}
			}
			if (sdata != rdata)
				PRINT_ERR((stderr,
					"bench: %d bytes sent, %d recvd\n",
					sdata, rdata))
			sdata += rdata;
			msg++;
#endif /* ETNA */
		}
#ifdef MTRACE
		/*
		 * Now stop.
		 */
		if (mtrace && i == MTR_STOP)
			mtraceoff();
#endif /* MTRACE */
#ifdef ETNA
		/*
		 * VR 19/06/95:
		 * Limit the time of each test to "duration" seconds.
		 */
		gettimeofday(&time2, NULL);
		if (duration > 0) {
			if (time2.tv_sec >= time0.tv_sec + duration)
				goto end_test;
		}
#endif	/* ETNA */
		Debit(num, sdata, msg);
next_iteration:
		;
	}

end_test:
	EndDebit();
}

#ifdef ETNA

/*
 * poll_incoming_event
 *
 * Wait at most timeout for an event to arrive.
 *	- with Socket API, use select,
 *	- with XTI API, use poll.
 */
STATIC int
poll_incoming_event (int	fd,
		     int	sec,
		     int	usec)
{
	int	res;

	if (xti) {
		struct pollfd	pfd[1];

		pfd[0].fd = fd;
		pfd[0].events = POLLIN | POLLPRI |
				POLLRDNORM | POLLRDBAND;
		res = poll(pfd, 1, usec + sec * 1000);
	} else {
		fd_set		readmask;
		struct timeval	timeout;

		FD_ZERO(&readmask);
		FD_SET(fd, &readmask);
		timeout.tv_sec = sec;
		timeout.tv_usec = usec;
		/* Warning: 1st param must be fd+1, not 1! */
		res = select(fd + 1, &readmask, (fd_set *)0, (fd_set *)0,
			     &timeout);
	}
	if (res < 0) {
		t_error("bench: poll/select failed");
		EXIT(0, 1);
	}
	return(res);
}

#endif /* ETNA */


STATIC void RelCon (fd, info)
int	fd;
struct t_info *info;
{
	int		evt;
	int		retl;
#if defined(ETNA)
	int		try = 0;	/* Limit the number of t_look() */
#define NTRY		20000		/* Max number of t_look() */
	struct pollfd	pfd[1];
#endif /* ETNA */

	if (info->servtype == T_COTS_ORD) {
		if (t_sndrel(fd) < 0) {
			t_error("bench: t_sndrel failed for fd");
			exit(1);
		}
#ifdef ETNA
		if (!silent)
#endif
			PRINT_OUT((stdout, "bench : orderly release initiated\n"))
		/*
		 * VR 04/01/95
		 * The right solution consists in polling the incoming
		 * messages in a blocking mode.
		 * This is not the case when we use t_look wich is totally
		 * synchronous and thereby alters performances.
		 */
		/* Ordearly release robustess (must accept T_DISCONNECT) */
		do {
			pfd[0].fd = fd;
			pfd[0].events = POLLIN | POLLPRI |
					POLLRDNORM | POLLRDBAND;
			if ((retl = poll(pfd,1,20*1000)) <= 0) {
				/* returns 0 if time exceeded, -1 if failed */
				if (retl < 0)
					t_error("bench: poll failed");
				else
					perror("bench: poll timeout, no discon");
				exit(1);
			}
			retl = t_look(fd);
		} while (retl != T_ORDREL && retl != T_DISCONNECT);
#ifdef NEVERDEF
#ifdef ETNA
		do
			retl = t_look(fd);
		while (retl != T_ORDREL && retl != T_DISCONNECT && ++try < NTRY);
		if (try == NTRY) {
			perror("bench: recvd no discon");
			exit(1);
		}
#else
		do
			retl = t_look(fd);
		while (retl != T_ORDREL && retl != T_DISCONNECT);
#endif /* ETNA */
#endif /* NEVERDEF */
		if (retl == T_ORDREL) {
			if (t_rcvrel(fd) < 0) {
				if (t_errno == TLOOK) {
					if ((evt = t_look(fd)) < 0) {
						t_error("bench: t_look failed for fd");
						exit(1);
					}
					PRINT_ERR((stderr, "bench: t_rcvrel evt : %x\n", evt))
				}
				t_error("bench: t_rcvrel failed for fd");
				exit(1);
			}
#ifdef ETNA
			if (!silent)
#endif
				PRINT_OUT((stdout, "bench: orderly release completed ok\n"))
		}
		else {
			if (t_rcvdis(fd , NULL) < 0) {
				t_error("bench: t_rcvdis failed for fd");
				exit(1);
			}
#ifdef ETNA
			if (!silent)
#endif
				PRINT_OUT((stdout, "bench: abortive disconnection received ok\n"))
		}
		/* End correction MR bsx32930059 */
	}
	else {
		if (t_snddis(fd, NULL) < 0) {
			t_error("bench: t_snddis failed for fd");
			exit(1);
		}
#ifdef ETNA
		if (!silent)
#endif
			PRINT_OUT((stdout, "bench: abortive disconnection requested ok\n"))
	}
}

#ifdef ETNA
/*
 * Set tcp nodelay option on with xti and socket APIs.
 *
 * The structures used in case of xti are:
 *
 *	struct t_optmgmt
 *	+------------------------------+
 *	| struct netbuf opt | . maxlen |    char re*opt[OPTHDR_LONG_SZ]
 *	|		    | . len    |    +---------------------------+
 *	|		    | . buf ---+--->| struct t_opthdr | . len	|
 *	| long flags		       |    |		      | . level |
 *	+------------------------------+    |		      | . name	|
 *					    |		      | . status|
 *					    | long (for mss)		|
 *					    +---------------------------+
 * - Struct t_optmgmt is used internaly by XTI and transformed into a
 * T_optmgmt_req struct by t_optmgmt() primitive.
 * - On return, the t_optmgmt() primitive initializes the len and flags
 * fields of t_optmgmt struct from the T_optmgmt_ack struct and copies
 * the t_opthdr returned by the transport protocol.
 */
STATIC int SetNodelayOption (fd)
int	fd;
{
	if (!xti) {
		int on = 1;

		if (setsockopt(fd,IPPROTO_TCP,TCP_NODELAY,&on,sizeof(on)) < 0)
			return(-1);
	} else {
		struct t_optmgmt	req;
		struct t_optmgmt	ret;
		struct netbuf		*np;
		struct t_opthdr		*op;
#define OPTHDR_LONG_SZ	sizeof(struct t_opthdr) + sizeof(long)
		char			reqopt[OPTHDR_LONG_SZ];
		char			retopt[OPTHDR_LONG_SZ];

		req.opt.maxlen = 0;
		req.opt.len = OPTHDR_LONG_SZ;
		req.opt.buf = reqopt;
		req.flags = T_NEGOTIATE;
		op = (struct t_opthdr*)reqopt;
		op->len = OPTHDR_LONG_SZ;
		op->level = IPPROTO_TCP;
		op->name = TCP_NODELAY;
		op->status = 0;				/* XXX: to check */
		*(long*)(op+1) = T_YES;			/* Set the TCP_NODELAY mode */

		ret.opt.maxlen = OPTHDR_LONG_SZ;
		ret.opt.len = 0;
		ret.opt.buf = retopt;
		ret.flags = 0;

		if (t_optmgmt(fd,&req,&ret))
			return(-1);

		op = (struct t_opthdr*)retopt;

		if (ret.opt.len != OPTHDR_LONG_SZ || op->len != OPTHDR_LONG_SZ)
			return(-1);		/* Error in protocol */

		if (op->level != T_SUCCESS || *(long*)(op+1) != T_YES)
			return(-1);
	}
	return(0);
}
#endif /* ETNA */

#endif /* } TLI */
