/* $Id: benchd.c,v 1.1.1.1 1998/12/02 16:51:36 roca Exp $ */
/*
 * benchd.c
 *
 *	Modified by : V.Roca
 *	Date	    : dec 1997
 *
 *	Server part of the performance evaluation tool.
 */
/*
 * (c) Copyright 1998 - V. Roca: this tool is provided as is, without
 * any warranty.
 * Permission to use, copy and modify is provided for non commercial
 * purposes as long as this notice appears on all copies.
 */

#include "bench.h"
#include "bench_proto.h"

extern char *optarg;
extern int getopt();


static int sync_fd;			/* fd to the synchronization conn */
static int sync_fd, sync2_fd;		/* fd to the synchronization conn */



void
main (int	argc,
      char	*argv[])
{
	int fd = 0;	/* to avoid warning */

	ParseCommandLine(argc, argv);
	PrintParams();
	if (sock)
		SockOpen();
#ifdef XTI
	else if (xti)
		XTIOpen();
#endif /* XTI */

	if (syncf)
		sync_setup();	/* start synchro with bench */

	signal(SIGCHLD, (sighandler_t)DeathChild);

	if (udp) {
#ifdef LINUX
		if (pin > 0) {
			/* pin all current and future segs to memory */
			if (mlockall(MCL_CURRENT | MCL_FUTURE) < 0) {
				perror("bench: mlockall");
				exit(-1);
			}
		}
#endif /* LINUX */
		while (1) {
			SockRecvUDPMsg();
		}
	} else if (tcp) {
		while (1) {
			if (sock) {
				fd = SockAccept();
			}
#ifdef XTI
			else if (xti) {
				XTIListen(0);
				fd = XTIAccept();
			}
#endif /* XTI */
			if (fd != DISCONNECT)
				Serve(fd);
		}
	}
	exit(0);
}


void
Serve (int	fd)
{
	connex++;
	if (dont_fork) {
		/*
		 * Enter directly in the child case!!! EndStats() will
		 * make the process exit() => no return problem.
		 */
		goto skip_fork;
	}

	switch (fork()) {
	case -1:	/* Error */
		perror("benchd: fork failed");
		exit(1);
		break;

	case 0:		/* Child */
#ifdef LINUX
		if (pin > 0) {
			/* pin all current and future segs to memory */
			if (mlockall(MCL_CURRENT | MCL_FUTURE) < 0) {
				perror("bench: mlockall");
				exit(-1);
			}
		}
#endif /* LINUX */
skip_fork:
		signal(SIGINT, (sighandler_t)Interrupted);

		if (sock) {
			close(listen_fd);
			SockRecvMsg(fd);
		}
#ifdef XTI
		else if (xti) {
			if (t_close(listen_fd) < 0) {
				t_error("benchd: t_close failed for listen_fd");
				exit(1);
			}
			XTIRecvMsg(fd);
		}
#endif /* XTI */
		exit(0);

	default:	/* Father */
		if (sock)
			close(fd);
#ifdef XTI
		else if (xti) {
			if (t_close(fd) < 0) {
				t_error("benchd: t_close failed for fd");
				exit(1);
			}
		}
#endif /* XTI */
		break;
	}
}


/****** Signal processing, and bench/benchd synchronization ******/

void
DeathChild (void)
{
	wait(0);
	/* dchild = 1; */
	signal(SIGCHLD, (sighandler_t)DeathChild);
}


/*
 * We received a SIGINT.
 */
void
Interrupted (void)
{
	EndStats();
	exit(0);
}


/*
 * Triggers statistics reset/print. Used with UDP only.
 * Sent by the sync client child when:
 *	- a new sync connection is opened => reset stats
 *	- the sync connection is closed => print stats
 */
void
IntUser1 (void)
{
	static int last_was_open = 0;	/* determine if this is a start */
					/* or stop call */

	if (!last_was_open) {		/* start of sync */
		/*
		 * Do as if nothing had ever been recvd.
		 */
		last_was_open = 1;
		ResetStats();
	} else {			/* end of sync */
#ifdef FAST_SYNC
		if (fast_stop_done) {
			/*
			 * We have already taken into account the fast stop
			 * message (STOP_MSG). Ignore this call to IntUser1
			 * from the sync child.
			 */
			fast_stop_done = 0;
		} else
#endif /* FAST_SYNC */
			EndStats();
		last_was_open = 0;
	}
	signal(SIGUSR1, (sighandler_t)IntUser1); /* ready for next time... */
}


/*
 * Setup synchronization.
 * Fork a process to handle the synchronization TCP connection.
 */
void
sync_setup (void)
{
	switch (fork()) {

	case -1:	/* Error */
		perror("benchd sync: fork failed");
		exit(1);
		break;

	case 0: {	/* Child */
		struct servent		*sp;

		/*
		 * Start the listening part of sync connection.
		 */
		if (sock) {
			struct sockaddr_in	sa;

			memset((char *)&sa, 0, sizeof(sa));
			sa.sin_family = AF_INET;
			sa.sin_addr.s_addr = htonl(INADDR_ANY);
			if (eport)
				sa.sin_port = htons(atoi(myport) + 1);
			else {
				if (!(sp = getservbyname("benchd_sync", "tcp"))) {
					PRINT_ERR((stderr, "benchd sync: don't know servername ""benchd_sync""\n"))
					exit(-1);
				}
				sa.sin_port = htons(sp->s_port);
			}

			if ((sync_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
				perror("benchd sync: socket");
				exit(-1);
			}
			if (bind(sync_fd, (struct sockaddr*)&sa, sizeof (sa)) < 0) {
				perror("benchd sync: bind");
				exit(1);
			}
			if (listen(sync_fd, SOMAXCONN) < 0) {
				perror("benchd sync: listen");
				exit(1);
			}
		}
#ifdef XTI
		else if (xti) {
#ifdef NOT_YET
			struct netbuf		*addr;
			struct sockaddr_in	*sa;
			struct xtitp		sync_tp;

			if (STD_stack)
				sync_tp.tp_id = TPID_STD_TCP;
			else if (CCA_stack)
				sync_tp.tp_id = TPID_CCA_UDP;
			else {
				t_error("benchd sync: bad stack");
				exit(-1);
			}
			if ((sync_fd = t_open(sync_tp.tp_name, O_RDWR, NULL)) < 0) {
				t_error("benchd sync: t_open failed");
				exit(-1);
			}
			if (((bind = (struct t_bind *)t_alloc(sync_fd,
						T_BIND_STR, T_ALL)) == NULL) ||
			    ((bindret = (struct t_bind *)t_alloc(sync_fd,
						T_BIND_STR, T_ALL)) == NULL)) {
				t_error("benchd sync: t_alloc failed");
				exit(-1);
			}
			sa = (struct sockaddr_in *)bind->addr.buf;
			sa->sin_len = sizeof(struct sockaddr_in);
			sa->sin_family = AF_INET;
			sa->sin_addr.s_addr = htonl(INADDR_ANY);
			sa->sin_port = htons(Sp->s_port);
			bind->addr.len = sizeof(struct sockaddr_in);
			bind->qlen = 1;		/* enough here */

			if (t_bind(sync_fd, bind, bindret) < 0) {
				t_error("benchd sync: t_bind failed");
				exit(1);
			}

			/* was the correct address bound ? */
			if ((bindret->addr.len != bind->addr.len) ||
	     		    (memcmp(bindret->addr.buf, bind->addr.buf,
				    bind->addr.len))) {
				t_error("benchd sync: t_bind bound wrong address\n");
				exit(-1);
			}	
			if ((call = (struct t_call *)t_alloc(sync_fd,
						T_CALL_STR, T_ALL)) == NULL) {
				t_error("benchd sync: t_alloc failed");
				exit(1);
			}
#else  /* NOT_YET */
			t_error("benchd sync: xti not yet supported\n");
			exit(-1);
#endif /* NOT_YET */
		}
#endif /* XTI */
		/*
		 * Now serve the start and end of session.
		 */
		while (1) {
			sync_start();
			sync_stop();
		}
		break;
		}

	default:	/* Father */
		/*
		 * Be ready for statistics reset/print.
		 */
		if (udp)
			signal(SIGUSR1, (sighandler_t)IntUser1);
		break;
	}
}


/*
 * sync_start
 */
void
sync_start (void)
{
	char	syncbuf[256];
	int	syncbuf_len;
	int	fromlen;
	struct sockaddr_in	from;

	if (sock) {
		fromlen = sizeof(from);
		if ((sync2_fd = accept(sync_fd, (struct sockaddr*)&from, &fromlen)) < 0) {
			perror("benchd tcp: accept");
			exit(1);
		}
		if ((syncbuf_len = recv(sync2_fd, syncbuf, sizeof(syncbuf), 0)) <= 0) {
			perror("benchd sync_start: recv");
			exit(1);
		}
	} else {
		PRINT_ERR((stderr, "benchd sync: xti not yet supported\n"))
		exit(1);
	}
	if (syncbuf_len <= strlen(SYNC_FORMAT) - 2) {
		/*
		 * Need to decr by 2 for the cases where the TSDU len and
		 * connection number are composed of one digit.
		 */
		PRINT_ERR((stderr, "benchd sync: bad data len %d", syncbuf_len))
		exit(1);
	}
	sscanf(syncbuf, SYNC_FORMAT, &lgthmsg, &nbconn);
	PRINT_OUT((stdout, "====== start sync ======\n"))
	PRINT_OUT((stdout, "SERVER_SYNC connect :\t\t%d\n", nbconn))
	PRINT_OUT((stdout, "SERVER_SYNC length of msg :\t%d\n", lgthmsg))
	/*
	 * Run the CPU usage tool.
	 */
	if (cpustat)
		if (cpustat == 1)
			system("sar -uw 5 2 &");
		else if (cpustat == 3)
			system("vmstat 2 6 &");
#if defined(CPUSTAT) && defined(BOSX41)
		else
			initstat();
#endif /* CPUSTAT && BOSX41 */
#ifdef BOSX41
	if (lockstat)
		system("lockstat -a -t200 15 1 &");
#endif /* BOSX41 */
	/*
	 * Reset statistics.
	 */
	if (udp)
		kill (getppid(), SIGUSR1);	
}


/*
 * Stop synchronization.
 * In UDP mode, ask the father to print a performance report.
 */
void
sync_stop (void)
{
	char	syncbuf[256];
	int	syncbuf_len;

	if ((syncbuf_len = recv(sync2_fd, syncbuf, sizeof(syncbuf), 0)) == 0) {
		/*
		 * The peer has closed the connection
		 * => print statistics and close our
		 * synchronization endpoint.
		 */
		if (udp)
			kill (getppid(), SIGUSR1);	
#if defined(CPUSTAT) && defined(BOSX41)
		if (cpustat == 2)
			stopstat();
#endif /* CPUSTAT && BOSX41 */
		close(sync2_fd);
		usleep((int)(1000000 / 2));	/* sleep a half second */
		PRINT_OUT((stdout, "====== end sync ======\n"))
		return;
	} else if (syncbuf_len < 0) {
		perror("benchd sync_stop: recv");
		exit(1);
	} else if (syncbuf_len > 0) {
		/*
		 * Error, we shouldn't receive anything here!
		 */
		PRINT_ERR((stderr, "benchd sync_stop: rcvd data\n"))
		exit(1);
	}
}

