/* $Id: benchd_sock.c,v 1.1.1.1 1998/12/02 16:51:36 roca Exp $ */
/*
 * benchd_sock.c
 *
 *	Modified by : V.Roca
 *	Date	    : dec 1997
 *
 *	Server part of the performance evaluation tool.
 *	Socket access method routines.
 */
/*
 * (c) Copyright 1998 - V. Roca: this tool is provided as is, without
 * any warranty.
 * Permission to use, copy and modify is provided for non commercial
 * purposes as long as this notice appears on all copies.
 */

#include "bench.h"
#include "bench_proto.h"


void
SockOpen (void)
{
	sa.sin_family = AF_INET;
	sa.sin_addr.s_addr = htonl(INADDR_ANY);

	if (eport)
		sa.sin_port = htons(atoi(myport));
	else {
		struct servent *sp;

		if (!(sp = getservbyname(servername, (tcp) ? "tcp" : "udp"))) {
			PRINT_OUT((stdout, "benchd: don't know servername ""%s""\n", servername))
			exit(1);
		}
		sa.sin_port = htons(sp->s_port);
	}

	if (tcp) {
		if ((listen_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
			perror("benchd tcp: socket");
			exit(1);
		}
	}
	else if ((listen_fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		perror("benchd udp: socket");
		exit(1);
	}

	if (bind(listen_fd, (struct sockaddr*)&sa, sizeof (sa)) < 0) {
		perror("benchd: bind");
		exit(1);
	}

	/*
	 * Must be done here because of a difference in behaviour
	 * when compared to xti: no need to create a second
	 * transport endpoint to transfer the connection on it.
	 */
	if (nodelay) {
		int on = 1;

		if (setsockopt(listen_fd,IPPROTO_TCP,TCP_NODELAY,&on,sizeof(on)) < 0) {
			perror("benchd: SetNodelayOption failed");
			exit(1);
		}
	}
	if (tcp) {
		if (listen(listen_fd, SOMAXCONN) < 0) {
			perror("benchd tcp: listen");
			exit(1);
		}
	}
}


int
SockAccept(void)
{
	if ((conn_fd = accept(listen_fd, (struct sockaddr*)&from, &fromlen)) < 0) {
		perror("benchd tcp: accept");
		exit(1);
	}
	return(conn_fd);
}


void
SockRecvUDPMsg (void)
{
	int	rdata;
	int	sdata;
	float	tt;

	ASSERT(udp)
#ifndef FAST_SYNC	/* done in ResetStats() with FAST_SYNC */
	gettimeofday(&time0, NULL);
	time1 = time0;
#endif
	while (1) {
		rdata = recvfrom(listen_fd, (char*)&recbuf, recbuf_size, 0,
				(struct sockaddr*)&from, &fromlen);
#ifdef BOSX41
		CCA_TRCHKL1T(CCA_USER_HKWD | benchd_rcv_end, rdata);
#endif
		if (rdata < 0) {
			if(errno != EINTR)
				perror("benchd udp: recvfrom");
		}
#ifdef FAST_SYNC
		else if (rdata == START_STOP_MSG_SIZE) {
			if (strcmp(recbuf, START_MSG) == 0) {
				/* start message; reset stats and continue */
				ResetStats();
				continue;
			} else {
				/* stop message; print stats and return */
				fast_stop_done = 1;
				EndStats();
				return;
			}
		}
#endif /* FAST_SYNC */
#define UDP_LOSS
#ifdef UDP_LOSS
		else if ((rdata >= sizeof(u_short)) && (*(u_short*)recbuf != udp_count)) {
			long diff;
			/* one or several UDP packets have been lost */
			diff = (*(u_short*)recbuf) - udp_count;
			if (diff < 0)
				diff += (u_short)0xffff; /* counter cycle */
#ifdef DEBUG
				if (!(diff>=0 && diff<=(u_short)0xffff)) {
					printf("short=%d, long=%d\n",
						sizeof(u_short), sizeof(long));
					printf("rdata=%d, *recbuf=%d, udp_count=%d, diff=%ld\n", rdata, (*(u_short*)recbuf), udp_count, diff);
					sleep(0);
				}
#endif /* DEBUG */
			ASSERT (diff>=0 && diff<=(u_short)0xffff)
			udp_loss += (int)diff;
			udp_count = *(u_short*)recbuf + 1;
		}
#endif /* UDP_LOSS */
		else {
			udp_count++;
		}
		if (mode == TT_MODE && rdata >= sizeof(u_short) + sizeof(struct timeval)) {
			/*
			 * read the timestamp which is stored
			 * just after the UDP packet count
			 */
			struct timeval	cur_time;
			struct timeval	*timestamp;

			gettimeofday(&cur_time, NULL);
			timestamp = (struct timeval*)(recbuf + sizeof(u_short));
			tt = (float)(cur_time.tv_sec - timestamp->tv_sec) +
			     (float)(cur_time.tv_usec - timestamp->tv_usec) * 1.0e-6;
#ifdef NEVERDEF
			printf("benchd: tt=%f, timestamp (sec=%ld, usec=%ld) cur_time (sec=%ld, usec=%ld)\n",
				tt, timestamp->tv_sec, timestamp->tv_usec,
				cur_time.tv_sec, cur_time.tv_usec);
#endif /* NEVERDEF */
		} else
			tt = 0.0; 	/* don't care */

		if (mode == RTT_MODE) {
			if ((sdata = sendto(listen_fd, (char*)&recbuf, rdata, 0,
			   (struct sockaddr*)&from, fromlen)) <= 0) {
				perror("benchd udp: sendto");
				exit(1);
			}
			if (rdata != sdata)
				PRINT_ERR((stderr,
				"benchd: %d bytes rcvd, %d bytes snt\n",
				rdata, sdata))
#ifdef BOSX41
			CCA_TRCHKL1T(CCA_USER_HKWD | benchd_snd_end, sdata);
#endif
		}
		/*
		 * In rtt mode, do not take sent
		 * data into account for the statistics.
		 * It yields erroneous results.
		 */
		Stats(0, rdata, 1, tt);
	}
}


void
SockRecvMsg (int	fd)
{
	int rdata;
	int sdata;
#ifdef MTRACE
	int i = 0;		/* iteration count used to trigger mtrace */
#endif /* MTRACE */

	ASSERT(tcp)
	PRINT_OUT((stdout, "benchd: starting connection %d\n", connex))

	gettimeofday(&time0, NULL);
	time1 = time0;
	while (1) {
#ifdef MTRACE
		/*
		 * Do not start immediately. Wait a while to be sure
		 * the working set is in memory and tcp in normal data
		 * transfer.
		 */
#define MTR_START	200
#define MTR_STOP	200
		if (mtrace && ++i == MTR_START)
			mtraceon();
#endif /* MTRACE */
		if ((rdata = recv(fd, recbuf, recbuf_size, 0)) <= 0) {
			if (dtonly) {
				/*
				 * Do stats only during data transfer.
				 */
				gettimeofday(&time2, NULL);
			}
			close(fd);
			break;
		}
#ifdef BOSX41
		CCA_TRCHKL1T(CCA_USER_HKWD | benchd_rcv_end, rdata);
#endif
		if (mode == RTT_MODE) {
			if ((sdata = send(fd, recbuf, rdata, 0)) <= 0) {
				perror("benchd: send");
				exit(1);
			}
			if (rdata != sdata)
				PRINT_ERR((stderr,
					"benchd: %d bytes rcvd, %d bytes snt\n",
					rdata, sdata))
#ifdef BOSX41
			CCA_TRCHKL1T(CCA_USER_HKWD | benchd_snd_end, sdata);
#endif
			/*
			 * In rtt mode, do not take sent
			 * data into account for the statistics.
			 * It yields erroneous results.
			 */
		}
#ifdef MTRACE
		/*
		 * Now stop.
		 */
		if (mtrace && i == MTR_STOP)
			mtraceoff();
#endif /* MTRACE */
		Stats(connex, rdata, 1, 0.0);
	}
	if (!silent)
		PRINT_OUT((stdout, "benchd: end connection %d\n", connex))
	EndStats();
}
