/* $Id: benchd_xti.c,v 1.1.1.1 1998/12/02 16:51:37 roca Exp $ */
/*
 * benchd_xti.c
 *
 *	Modified by : V.Roca
 *	Date	    : dec 1997
 *
 *	Server part of the performance evaluation tool.
 */
/*
 * (c) Copyright 1998 - V. Roca: this tool is provided as is, without
 * any warranty.
 * Permission to use, copy and modify is provided for non commercial
 * purposes as long as this notice appears on all copies.
 */
#ifdef XTI

#include "bench.h"
#include "bench_proto.h"

extern char *optarg;
extern int getopt();

extern int dont_fork;

static pid_t tab_pid[MAX_CONNECT];
static int sync_fd;			/* fd to the synchronization conn */
static int flag_on;			/* indicates SIGUSR1 occured */



#define DISCONNECT		-1



static int lgthmsg;			/* used in case of synchronization */
static char recbuf[MAX_RCVBUF_SIZE];	/* change in MAX_DATA_SIZE semantics */
static int sync_fd, sync2_fd;		/* fd to the synchronization conn */
static int listen_fd, fromlen;
static struct sockaddr_in from;
static int dchild;



main(argc, argv)
int argc;
char *argv[];
{
	int fd;

	CommandLine(argc, argv);
	PrintParams (void);
	if (sock)
		SockOpen(0);
#ifdef XTI
	else if (xti)
		XTIOpen(0);
#endif /* XTI */
	gettimeofday(&time0, NULL);
	time1 = time0;

	if (syncf)
		sync_setup();	/* start synchro with bench */

	signal(SIGCHLD, DeathChild);

	while (1) {
		Listen();
		if ((fd = Accept()) != DISCONNECT)
			Serve(fd);
	}
	exit(0);
}


void Open()
{
#ifdef XTI
	if (xti) {
		struct t_bind *bind;

		if ((listen_fd = t_open(tp.tp_name, O_RDWR, NULL)) < 0) {
			t_error("benchd: t_open failed for listen_fd");
			exit(1);
		}

		if ((bind = (struct t_bind *)t_alloc(listen_fd, T_BIND_STR, T_ALL))
	             	== NULL) {
			t_error("benchd: t_alloc failed for bind");
			exit(1);
		}

		/*
		 * the server endpoint is used to listen for connect ind
		 */
		if (eport) {
			struct sockaddr_in *sa;

			sa = (struct sockaddr_in *)bind->addr.buf;
#ifdef ncl2
			sa->sin_len = sizeof(struct sockaddr_in);
#endif
			sa->sin_family = AF_INET;
			sa->sin_addr.s_addr = INADDR_ANY;
			sa->sin_port = atoi(myport);
			bind->addr.len = sizeof(struct sockaddr_in);
		}
		else if (t_getladdr(&tp, servername, &bind->addr)) {
			t_error_ns("benchd: t_getladdr failed");
			exit(1);
		}

		/*
		 * Do as in socket mode. benchd should be able to
		 * have several outstanding connect indications.
		 */
		bind->qlen = SOMAXCONN;

		if ((bindret = (struct t_bind *)t_alloc(listen_fd, T_BIND_STR, T_ALL))
	             	== NULL) {
			t_error("benchd: t_alloc failed for bindret");
			exit(1);
		}
	
		if (t_bind(listen_fd, bind, bindret) < 0) {
			t_error("benchd: t_bind failed for listen_fd");
			exit(1);
		}

		/* was the correct address bound ? */
		if ((bindret->addr.len != bind->addr.len) || /* DBXBP TBD */
	     	(memcmp(bindret->addr.buf, bind->addr.buf, bind->addr.len))) {
			PRINT_ERR((stderr, "benchd: t_bind bound wrong address\n"))
			exit(1);
		}	

		if (udp) {
			if ((ud =(struct t_unitdata *)(t_alloc(listen_fd,
					T_UNITDATA_STR, T_ALL))) == NULL) {
				t_error("benchd: t_alloc failed for t_unitdata structure");
				exit(1);
			}
		
			if ((uderr = (struct t_uderr *)(t_alloc(listen_fd, 
					T_UDERROR_STR, T_ALL))) == NULL) {
				t_error("benchd: t_alloc failed for t_uderr structure");
				exit(1);
			}
		}
		else {
			if ((call = (struct t_call *)t_alloc(listen_fd, T_CALL_STR, 
								T_ALL)) == NULL) {
				t_error("benchd: t_alloc failed for call");
				exit(1);
			}
		}
	} else
#endif /* XTI */
	if (sock) { /* socket */
		sa.sin_family = AF_INET;
		sa.sin_addr.s_addr = INADDR_ANY;

		if (eport)
			sa.sin_port = atoi(myport);
		else {
			struct servent *sp;

			if (!(sp = getservbyname(servername, (tcp) ? "tcp" : "udp"))) {
				PRINT_OUT((stdout, "benchd: don't know servername ""%s""\n", servername))
				exit(1);
			}
			sa.sin_port = sp->s_port;
		}
	
		if (tcp) {
			if ((listen_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
				perror("benchd tcp: socket");
				exit(1);
			}
		}
		else if ((listen_fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
			perror("benchd udp: socket");
			exit(1);
		}

		if (bind(listen_fd, &sa, sizeof (sa)) < 0) {
			perror("benchd: bind");
			exit(1);
		}

		/*
		 * Must be done here because of a difference in behaviour
		 * when compared to xti: no need to create a second
		 * transport endpoint to transfer the connection on it.
		 */
		if (nodelay && SetNodelayOption(listen_fd) < 0) {
			perror("benchd: SetNodelayOption failed");
			exit(1);
		}
		if (tcp) {
			if (listen(listen_fd, SOMAXCONN) < 0) {
				perror("benchd tcp: listen");
				exit(1);
			}
		}
	}
}


void Listen()
{
#ifdef XTI
	if (xti) {
		if (udp) {
			int flags;

			if (t_rcvudata(listen_fd, ud, &flags) < 0) {
				if (t_errno == TLOOK) {
					/* error on previously sent datagram */
					if (t_rcvuderr(listen_fd, uderr) < 0) {
						t_error("benchd: t_rcvuderr failed");
						exit (10);
					}
	
					PRINT_ERR((stderr, "benchd: bad datagram, error=%d\n",
							uderr->error))
					return;
				}
				t_error("benchd: t_rcvudata failed");
				exit (11);
			}
			CCA_TRCHKL1T(CCA_USER_HKWD | benchd_rcv_end,
				     ud->udata.len);
			Debit(0, ud->udata.len, 1);
		} else {
			do {
				dchild = 0;
				if (t_listen(listen_fd, call) < 0 && !dchild) {
					t_error("benchd: t_listen failed for listen_fd");
					if (t_errno == TLOOK)
						PRINT_ERR((stderr,
						"benchd: rcvd event %d\n",
						t_look(listen_fd)))
					exit(1);
				}
			} while (dchild);
		}
	} else
#endif /* XTI */
	if (sock) { /* socket */
		if (udp) {
			int	rdata;
			int	sdata;
			int	errno = 0;

			rdata = recvfrom(listen_fd, &recbuf, recbuf_size, 0,
					&from, &fromlen);
			if (rdata <= 0) {
				if(errno != EINTR)
					perror("benchd udp: recv");
			} 
			CCA_TRCHKL1T(CCA_USER_HKWD | benchd_rcv_end, rdata);
			if (rtt) {
				if ((sdata = sendto(listen_fd, &recbuf, rdata, 0, &from, fromlen)) <= 0) {
					perror("benchd: sendto");
					exit(1);
				}
				if (rdata != sdata)
					PRINT_ERR((stderr,
					"benchd: %d bytes rcvd, %d bytes snt\n",
					rdata, sdata))
				CCA_TRCHKL1T(CCA_USER_HKWD | benchd_snd_end,
				     sdata);
			}
			/*
			 * In rtt mode, do not take sent
			 * data into account for the statistics.
			 * It yields erroneous results.
			 */
			Debit(0, rdata, 1);
		}
	}
}

int Accept()
{
	if (udp)
		return DISCONNECT;

	if (xti) {
		if ((conn_fd = t_open(tp.tp_name, O_RDWR, NULL)) < 0) {
			t_error("benchd: t_open failed for conn_fd");
			exit(1);
		}
		bindret->qlen = 0;
	
		if (osi) {
			if (t_bind(conn_fd, bindret, NULL) < 0) { 
				t_error("benchd: t_bind failed for conn_fd");
				exit(1);
			}
		}
		else
			if (t_bind(conn_fd, NULL, NULL) < 0) { 
				t_error("benchd: t_bind failed for conn_fd");
				exit(1);
			}

#ifdef ETNA
		if (nodelay && SetNodelayOption(conn_fd) < 0) {
			t_error("benchd: SetNodelayOption failed for conn_fd");
			exit(1);
		}
#endif /* ETNA */
		/*call->sequence is actually initialized */
		/*because returned by t_listen*/
		call->addr.len = 0;
		call->opt.len = 0;
		call->udata.len = 0;
		do {
			dchild = 0;
			if (t_accept(listen_fd, conn_fd, call) < 0 && !dchild) {
				if (t_errno == TLOOK) {
					if (t_rcvdis(listen_fd , NULL) < 0) {
						t_error("benchd: t_rcvdis failed for listen_fd");
						exit(1);
					}
					if (t_close(conn_fd) < 0) {
						t_error("benchd: t_close failed for conn_fd");
						exit(1);
					}
					return(DISCONNECT);
				}
				t_error("benchd: t_accept failed");
				exit(1);
			}
		}
		while (dchild);
	}
	else {
		do {
			dchild = 0;
			if ((conn_fd = accept(listen_fd, &from, &fromlen)) < 0 && !dchild) {
				perror("benchd tcp: accept");
				exit(1);
			}
		}
		while (dchild);
	}
	return(conn_fd);
}

void Serve(fd)
int fd;
{
	connex++;
#ifdef ETNA
	if (dont_fork)
		/*
		 * Enter directly in the case. EndDebit() will make
		 * the process exit() => no return problem.
		 */
		goto skip_fork;
#endif /* ETNA */

	switch (fork()) {
	case -1:	/* Error */
		perror("benchd: fork failed");
		exit(1);
		break;

	case 0:		/* Child */
#ifdef ETNA
skip_fork:
		signal(SIGINT, Interrupted);	/* EndDebit no longer exits */
#else  /* ETNA */
		signal(SIGINT, EndDebit);
#endif /* ETNA */

		if (xti) {
			if (t_close(listen_fd) < 0) {
				t_error("benchd: t_close failed for listen_fd");
				exit(1);
			}
		} else
			close(listen_fd);

		RecvMsg(fd);

		exit(0);

	default:	/* Father */
		if (xti) {
			if (t_close(fd) < 0) {
				t_error("benchd: t_close failed for fd");
				exit(1);
			}
		} else
			close(fd);
		break;
	}
}



#ifdef ETNA
/*
 * Set tcp nodelay option on with xti and socket APIs.
 *
 * The structures used in case of xti are:
 *
 *	struct t_optmgmt
 *	+------------------------------+
 *	| struct netbuf opt | . maxlen |    char re*opt[OPTHDR_LONG_SZ]
 *	|		    | . len    |    +---------------------------+
 *	|		    | . buf ---+--->| struct t_opthdr | . len	|
 *	| long flags		       |    |		      | . level |
 *	+------------------------------+    |		      | . name	|
 *					    |		      | . status|
 *					    | long (for mss)		|
 *					    +---------------------------+
 * - Struct t_optmgmt is used internaly by XTI and transformed into a
 * T_optmgmt_req struct by t_optmgmt() primitive.
 * - On return, the t_optmgmt() primitive initializes the len and flags
 * fields of t_optmgmt struct from the T_optmgmt_ack struct and copies
 * the t_opthdr returned by the transport protocol.
 */
int SetNodelayOption (fd)
int	fd;
{
	if (!xti) {
		int on = 1;

		if (setsockopt(fd,IPPROTO_TCP,TCP_NODELAY,&on,sizeof(on)) < 0)
			return(-1);
	} else {
		struct t_optmgmt	req;
		struct t_optmgmt	ret;
		struct netbuf		*np;
		struct t_opthdr		*op;
#define OPTHDR_LONG_SZ	sizeof(struct t_opthdr) + sizeof(long)
		char			reqopt[OPTHDR_LONG_SZ];
		char			retopt[OPTHDR_LONG_SZ];

		req.opt.maxlen = 0;
		req.opt.len = OPTHDR_LONG_SZ;
		req.opt.buf = reqopt;
		req.flags = T_NEGOTIATE;
		op = (struct t_opthdr*)reqopt;
		op->len = OPTHDR_LONG_SZ;
		op->level = IPPROTO_TCP;
		op->name = TCP_NODELAY;
		op->status = 0;				/* XXX: to check */
		*(long*)(op+1) = T_YES;			/* Set the TCP_NODELAY mode */

		ret.opt.maxlen = OPTHDR_LONG_SZ;
		ret.opt.len = 0;
		ret.opt.buf = retopt;
		ret.flags = 0;

		if (t_optmgmt(fd,&req,&ret))
			return(-1);

		op = (struct t_opthdr*)retopt;

		if (ret.opt.len != OPTHDR_LONG_SZ || op->len != OPTHDR_LONG_SZ)
			return(-1);		/* Error in protocol */

		if (op->level != T_SUCCESS || *(long*)(op+1) != T_YES)
			return(-1);
	}
	return(0);
}
#endif /* ETNA */




void DeathChild()
{
	wait(0);
	dchild = 1;
	signal(SIGCHLD, DeathChild);
}

#ifdef ETNA
/*
 * We received a SIGINT.
 */
void Interrupted (void)
{
	EndDebit();
	exit(0);
}

/*
 * Triggers statistics reset/print. Used with UDP only.
 * Sent by the sync child when:
 *	- a new sync connection is opened => reset stats,
 *	- the sync connection is closed => print stats.
 */
void IntUser1 (void)
{
	static int last_was_open = 0;

	if (!last_was_open) {		/* start of sync */
		/*
		 * Do as if nothing had ever been recvd.
		 */
		last_was_open = 1;
		totdata = 0;
		totmsg = 0;
		recdata = 0;
		recmsg = 0;
		min_recdata = 1000000;
		max_recdata = 0;
		fthrumin = 1000000.0;
		fthrumax = 0.0;
		gettimeofday(&time1, NULL);
		time0 = time1;
	} else {			/* end of sync */
		EndDebit();
		last_was_open = 0;
	}
	signal(SIGUSR1, IntUser1);	/* ready for next time... */
}

/*
 * Setup synchronization.
 * Fork a process to handle the synchronization TCP connection.
 */
void sync_setup (void)
{

	switch (fork()) {

	case -1:	/* Error */
		perror("benchd sync: fork failed");
		exit(1);
		break;

	case 0: {	/* Child */
		struct servent		*sp;

		/*
		 * Start the listening part of sync connection.
		 */
		if (!(sp = getservbyname("benchd_sync", "tcp"))) {
			PRINT_ERR((stderr,
			"benchd sync: don't know servername ""benchd_sync""\n"))
			exit(-1);
		}
		if (!xti) {
			struct sockaddr_in	sa;

			memset((char *)&sa, 0, sizeof(sa));
			sa.sin_family = AF_INET;
			sa.sin_addr.s_addr = INADDR_ANY;
			sa.sin_port = sp->s_port;
			if ((sync_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
				perror("benchd sync: socket");
				exit(-1);
			}
			if (bind(sync_fd, &sa, sizeof (sa)) < 0) {
				perror("benchd sync: bind");
				exit(1);
			}
			if (listen(sync_fd, SOMAXCONN) < 0) {
				perror("benchd sync: listen");
				exit(1);
			}
		} else {	/* XTI case */
#ifdef NOT_YET
			struct netbuf		*addr;
			struct sockaddr_in	*sa;
			struct xtitp		sync_tp;

			if (STD_stack)
				sync_tp.tp_id = TPID_STD_TCP;
			else if (CCA_stack)
				sync_tp.tp_id = TPID_CCA_UDP;
			else {
				t_error("benchd sync: bad stack");
				exit(-1);
			}
			if ((sync_fd = t_open(sync_tp.tp_name, O_RDWR, NULL)) < 0) {
				t_error("benchd sync: t_open failed");
				exit(-1);
			}
			if (((bind = (struct t_bind *)t_alloc(sync_fd,
						T_BIND_STR, T_ALL)) == NULL) ||
			    ((bindret = (struct t_bind *)t_alloc(sync_fd,
						T_BIND_STR, T_ALL)) == NULL)) {
				t_error("benchd sync: t_alloc failed");
				exit(-1);
			}
			sa = (struct sockaddr_in *)bind->addr.buf;
			sa->sin_len = sizeof(struct sockaddr_in);
			sa->sin_family = AF_INET;
			sa->sin_addr.s_addr = INADDR_ANY;
			sa->sin_port = Sp->s_port;
			bind->addr.len = sizeof(struct sockaddr_in);
			bind->qlen = 1;		/* enough here */

			if (t_bind(sync_fd, bind, bindret) < 0) {
				t_error("benchd sync: t_bind failed");
				exit(1);
			}

			/* was the correct address bound ? */
			if ((bindret->addr.len != bind->addr.len) ||
	     		    (memcmp(bindret->addr.buf, bind->addr.buf,
				    bind->addr.len))) {
				t_error(benchd sync: t_bind bound wrong address\n");
				exit(-1);
			}	
			if ((call = (struct t_call *)t_alloc(sync_fd,
						T_CALL_STR, T_ALL)) == NULL) {
				t_error("benchd sync: t_alloc failed");
				exit(1);
			}
#else  /* NOT_YET */
			t_error("benchd sync: xti not yet supported\n");
			exit(-1);
#endif /* NOT_YET */
		}
		/*
		 * Now serve the start and end of session.
		 */
		while (1) {
			sync_start();
			sync_stop();
		}
		break;
		}

	default:	/* Father */
		/*
		 * Be ready for statistics reset/print.
		 */
		if (udp)
			signal(SIGUSR1, IntUser1);
		break;
	}
}

/*
 * sync_start
 */
void sync_start (void)
{
	char	syncbuf[256];
	int	syncbuf_len;
	int	fromlen;
	struct sockaddr_in	from;

	if (!xti) {
		fromlen = sizeof(from);
		if ((sync2_fd = accept(sync_fd, &from, &fromlen)) < 0) {
			perror("benchd tcp: accept");
			exit(1);
		}
		if ((syncbuf_len = recv(sync2_fd, syncbuf, sizeof(syncbuf), 0)) <= 0) {
			perror("benchd sync_start: recv");
			exit(1);
		}
	}
	if (syncbuf_len <= strlen(SYNC_FORMAT) - 2) {
		/*
		 * Need to decr by 2 for the cases where the TSDU len and
		 * connection number are composed of one digit.
		 */
		PRINT_ERR((stderr, "benchd sync: bad data len %d", syncbuf_len))
		exit(1);
	}
	sscanf(syncbuf, SYNC_FORMAT, &lgthmsg, &nbconn);
	PRINT_OUT((stdout, "====== start sync ======\n"))
	PRINT_OUT((stdout, "SERVER_SYNC connect :\t\t%d\n", nbconn))
	PRINT_OUT((stdout, "SERVER_SYNC length of msg :\t%d\n", lgthmsg))
	/*
	 * Run the CPU usage tool.
	 */
	if (cpustat)
		if (cpustat == 1)
			system("sar -uw 5 2 &");
		else if (cpustat == 3)
			system("vmstat 2 6 &");
#if defined(CPUSTAT) && defined(BOSX41)
		else
			initstat();
#endif /* CPUSTAT && BOSX41 */
#ifdef BOSX41
	if (lockstat)
		system("lockstat -a -t200 15 1 &");
#endif /* BOSX41 */
	/*
	 * Reset statistics.
	 */
	if (udp)
		kill (getppid(), SIGUSR1);	
}

/*
 * Stop synchronization.
 * In UDP mode, ask the father to print a performance report.
 */
void sync_stop (void)
{
	char	syncbuf[256];
	int	syncbuf_len;

	if ((syncbuf_len = recv(sync2_fd, syncbuf, sizeof(syncbuf), 0)) == 0) {
		/*
		 * The peer has closed the connection
		 * => print statistics and close our
		 * synchronization endpoint.
		 */
		if (udp)
			kill (getppid(), SIGUSR1);	
#if defined(CPUSTAT) && defined(BOSX41)
		if (cpustat == 2)
			stopstat();
#endif /* CPUSTAT && BOSX41 */
		close(sync2_fd);
		usleep((int)(1000000 / 2));	/* sleep a half second */
		PRINT_OUT((stdout, "====== end sync ======\n", lgthmsg))
		return;
	} else if (syncbuf_len < 0) {
		perror("benchd sync_stop: recv");
		exit(1);
	} else if (syncbuf_len > 0) {
		/*
		 * Error, we shouldn't receive anything here!
		 */
		PRINT_ERR((stderr, "benchd sync_stop: rcvd data\n"))
		exit(1);
	}
}

#endif /* ETNA */

STATIC void RecvMsg(fd)
int fd;
{
	int rdata, sdata, msg, flags, evt;
#ifdef MTRACE
	int i = 0;		/* iteration count used to trigger mtrace */
#endif /* MTRACE */

	PRINT_OUT((stdout, "benchd: starting connection %d\n", connex))

	gettimeofday(&time0, NULL);
	time1 = time0;
	while (1) {
#ifdef MTRACE
		/*
		 * Do not start immediately. Wait a while to be sure
		 * the working set is in memory and tcp in normal data
		 * transfer.
		 */
#define MTR_START	200
#define MTR_STOP	200
		if (mtrace && ++i == MTR_START)
			mtraceon();
#endif /* MTRACE */
		if (xti) {
#ifdef ETNA
			switch (rcv_version) {
			case 0:
				/*
				 * standard t_rcv().
				 */
               			if ((rdata = t_rcv(fd, recbuf, recbuf_size,
						   &flags)) < 0) {
					if (t_errno != TLOOK) {
						t_error("benchd: t_rcv failed for fd");
                        			exit(1);
					}
					while (t_look(fd) < 0)
						t_error("benchd: can't look rcv evt");
					ConnRelease(fd);
					if (t_close(fd) < 0) {
						t_error("benchd: t_close failed for fd");
						exit(1);
					}
                               		goto closed;
				}
				break;
			case 1:
				/*
				 * t_rcv1() using read.
				 *
				 * NB: with this mode, connection
				 * release is indicated with a 0
				 * returned value. The appropriate
				 * T_DISCON_REQ or T_ORDREL_REQ is
				 * then transmitted by tirdwr.
				 */
               			if ((rdata = t_rcv1(fd, recbuf, recbuf_size,
						   &flags)) <= 0) {
					if (rdata < 0) {
						t_error("benchd: t_rcv1 failed for fd");
						exit(1);
					}
					if (dtonly)
						/*
						 * Do stats only during
						 * data transfer.
						 */
						gettimeofday(&time2, NULL);
					if (!silent)
						PRINT_OUT((stdout, "benchd: release received\n"))
					/* close(fd); */
					if (t_close(fd) < 0) {
						t_error("benchd: t_close failed for fd");
						exit(1);
					}
					goto closed;
				}
				break;
                	}
#endif /* ETNA */
		} else if ((rdata = recv(fd, recbuf, recbuf_size, 0)) <= 0) {
#ifdef ETNA
			if (dtonly)
				/*
				 * Do stats only during data transfer.
				 */
				gettimeofday(&time2, NULL);
#endif /* ETNA */
			close(fd);
			break;
		}
		msg = 1;
		CCA_TRCHKL1T(CCA_USER_HKWD | benchd_rcv_end, rdata);
		if (interactive) {
			if (xti) {
#ifdef ETNA
				int error = 0;

				switch (snd_version) {
				case 0:
					/*
					 * standard t_snd()
					 */
					sdata = t_snd(fd, recbuf,
						      rdata, 0);
					if (sdata < 0)
						error = 1;
					break;
				case 1:
					/*
					 * t_snd1() using write()
					 * internaly
					 */
					 sdata = t_snd1(fd, recbuf,
							rdata, 0);
					if (sdata < 0)
						error = 1;
					break;
				case 2:
					/*
					 * use write() directly
					 */
					sdata = write(fd, recbuf, rdata);
					if (sdata < rdata)
						error = 1;
					break;
				case 3:
					/*
					 * t_snd2() using putpmsg()
					 * w/o ctrl buf.
					 */
					sdata = t_snd2(fd, recbuf,
						       rdata, 0);
					if (sdata < 0)
						error = 1;
					break;
#ifdef ETNA_XTISEG
				case 4:
					/*
					 * t_sndseg() using putextmsg
					 * w/o ctrl buf.
					 * T_MORE not set to push data
					 */
					sdata = t_sndseg(fd, recbuf,
							 rdata, 0);
					if (sdata < 0)
						error = 1;
					break;
				case 5:
					/*
					 * t_sndseg() using putextmsg()
					 * w/o ctrl buf and with cksum
					 * T_MORE not set to push data
					 */
					sdata = t_sndseg(fd, recbuf,
							 rdata,
							 T_COPYANDCKSUM);
					if (sdata < 0)
						error = 1;
					break;
#endif /* ETNA_XTISEG */
				}

				if (error) {
					if (t_errno == TLOOK) {
						PRINT_ERR((stderr, "benchd: t_snd, conn aborted\n"))
						exit(1);
					}
					t_error("benchd: t_snd failed for conn_fd");
					exit(1);
				}
#else  /* ETNA */
				if ((sdata = t_snd(fd, recbuf, rdata, 0)) < 0) {
					if (t_errno == TLOOK) {
						PRINT_ERR((stderr, "benchd: t_snd, conn aborted\n"))
						exit(1);
					}
					t_error("benchd: t_snd failed for conn_fd");
					exit(1);
				}
#endif /* ETNA */
			} else {
				if ((sdata = send(fd, recbuf, rdata, 0)) <= 0) {
					perror("benchd: send");
					exit(1);
				}
			}
			if (rdata != sdata)
				PRINT_ERR((stderr,
					"benchd: %d bytes rcvd, %d bytes snt\n",
					rdata, sdata))
			CCA_TRCHKL1T(CCA_USER_HKWD | benchd_snd_end,
				     sdata);
#ifdef ETNA
			/*
			 * In interactive mode, do not take sent
			 * data into account for the statistics.
			 * It yields erroneous results.
			 */
#else  /* ETNA */
			rdata += sdata;
			msg++;
#endif /* ETNA */
		}
#ifdef MTRACE
		/*
		 * Now stop.
		 */
		if (mtrace && i == MTR_STOP)
			mtraceoff();
#endif /* MTRACE */
		Debit(connex, rdata, msg);
	}
closed:
#ifdef ETNA
		if (!silent)
#endif
			PRINT_OUT((stdout, "benchd: end connection %d\n", connex))
		EndDebit();
}

#endif /* XTI */
