/* $Id: stats.c,v 1.1.1.1 1998/12/02 16:51:35 roca Exp $ */
/*
 * stats.c
 *
 *	Modified by : V.Roca
 *	Date	    : dec 1997
 *
 *	bench/benchd statistic routines.
 */
/*
 * (c) Copyright 1998 - V. Roca: this tool is provided as is, without
 * any warranty.
 * Permission to use, copy and modify is provided for non commercial
 * purposes as long as this notice appears on all copies.
 */

#include "bench.h"
#include "bench_proto.h"


/****** statistic gathering routines ******/


#ifdef SERVER
/*
 *	Used by both the IntUser1 and (Sock)RecvUDPMsg functions
 */
void
ResetStats (void)
{
	totdata = 0;
	totmsg = 0;
	recdata = 0;
	recmsg = 0;
	rectt = 0.0;
	min_recdata = 1000000;
	max_recdata = 0;
	min_tt = 1000000.0;
	max_tt = 0.0;
	fthrumin = 1000000.0;
	fthrumax = 0.0;
	udp_loss = 0;
	udp_count = 0;
	totudploss = 0;
	gettimeofday(&time0, NULL);
	time1 = time0;
}
#endif /* SERVER */


/*
 *	Used by both server and client to register/print partial
 *	statistics periodically.
 */
void
Stats (int	conn,
       int	data,
       int	msg,
       float	tt)
{
	float fthru, fmsg, dt;
	float fdelay;		/* latency */
#ifdef SERVER
	float av_recdata;	/* average recv buffer length */

	if (mode == RTT_MODE)
		return;
	if (raw) {
		/*
		 * do not calculate stats but print raw info
		 */
		gettimeofday(&time2, NULL);
		if (udp) {
			PRINT_OUT((stdout,
				"%ld.%06ld\t (%d) TT=%.3f ms %d L=%d lost_msg\n",
				time2.tv_sec, time2.tv_usec,
				data, tt * 1000.0, udp_count - 1, udp_loss))
			udp_loss = 0;
		} else {
			PRINT_OUT((stdout,
				"%ld.%06ld\t (%d) TT=%.3f ms\n",
				time2.tv_sec, time2.tv_usec, data, tt))
		}
		return;
	}
#endif /* SERVER */
	recdata += data;
	recmsg += msg;
#ifdef NEVERDEF
	printf("Stats: tt=%f, rectt=%f\n", tt, rectt);
#endif /* NEVERDEF */
#ifdef SERVER
	/*
	 * Additional statistics on receive buffer filling
	 */
	if (data > max_recdata)
		max_recdata = data;
	if (data < min_recdata)
		min_recdata = data;
	/*
	 * ... and transit time 
	 */
	rectt += tt;
	if (mode == TT_MODE) {
		if (tt > max_tt)
			max_tt = tt;
		if (tt < min_tt)
			min_tt = tt;
	}
	gettimeofday(&time2, NULL);
#else  /* CLIENT case */
	/* gettimeofday of time2 done in SendMsg */
#endif
 	if (time2.tv_sec >= time1.tv_sec + tmsg) {
		dt = time2.tv_sec - time1.tv_sec +
		     (time2.tv_usec - time1.tv_usec) * 1e-6;
		/*
		 * VR 17/3/98: done here to avoid differences in sender
		 * and receiver measures. Of course, printf execution time
		 * is included in measures  (if it is a problem, use
		 * large trace periods) !
		 */
		gettimeofday(&time1, NULL);

		fthru = recdata / (dt * 1024.0);
		if (fthru < fthrumin)
			fthrumin = fthru;
		if (fthru > fthrumax)
			fthrumax = fthru;
		fmsg = recmsg / dt;
		if (fmsg > 0.0)
			fdelay = 1000.0 / fmsg;
		else
			fdelay = -1.0;
#ifdef SERVER
		if (recmsg > 0)
			av_recdata = recdata / recmsg;
		else
			av_recdata = -1;
		if (udp) {
			if (mode == TT_MODE) {
				PRINT_OUT((stdout,
				"SERVER %s conn %d RCV TT=%.3f ms M=%.1f msg/s L=%.1f lost_msg/s\n",
				provider, conn, 1000.0 * rectt / (float)recmsg,
				fmsg, (float)udp_loss / dt))
				tottt += rectt;
				rectt = 0.0;
			} else {
				PRINT_OUT((stdout,
				"SERVER %s conn %d RCV T=%.1f Kbytes/s M=%.1f msg/s D=%.3f ms S=%d/%.1f/%d bytes/msg L=%.1f lost_msg/s\n",
				provider, conn, fthru, fmsg, fdelay,
				min_recdata, av_recdata, max_recdata,
				(float)udp_loss / dt))
			}
			totudploss += udp_loss;
			udp_loss = 0;
		} else if (tcp) {
			PRINT_OUT((stdout,
			"SERVER %s conn %d RCV T=%.1f Kbytes/s M=%.1f msg/s D=%.3f ms S=%d/%.1f/%d bytes/msg\n",
			provider, conn, fthru, fmsg, fdelay,
			min_recdata, av_recdata, max_recdata))
		}
		min_recdata = 1000000;
		max_recdata = 0;
#else  /* CLIENT case */
		PRINT_OUT((stdout,
			"CLIENT %s conn %d %s T=%.1f Kbytes/s M=%.1f msg/s D=%.3f ms\n",
			provider, conn, (mode == RTT_MODE ? "SNDRCV" : "SND"),
			fthru, fmsg, fdelay))
#endif
		totdata += recdata;
		totmsg += recmsg;
		recdata = recmsg = 0.0;
#ifdef NEVERDEF
		/*
		 * VR 22/07/94: for more precision, don't include PRINT_OUT
		 * in the estimation.
		 * VR 17/3/98: FALSE, leads to differences between sender
		 * and receiver measures !!! Moved above.
		 */
		gettimeofday(&time1, NULL);
#endif /* NEVERDEF */
	}
}


/*
 *	Used by both server and client to print statistics at
 *	the end of the test.
 */
void
EndStats (void)
{
	float fthru, fmsg, dt;
	float fdelay;		/* latency */
	char  stats[1024];
	char  add_stats[256];
#ifdef SERVER
	float av_totdata;	/* average recv buffer length */
	float av_tottt;		/* average transit time */

	if (mode == RTT_MODE)
		return;
	if (raw)
		return;
#else  /* CLIENT case */
	if (dtonly) {
		/*
		 * Do statistics only during data transfer.
		 */
		gettimeofday(&time2, NULL);
	}
	if (sock)
		close(conn_fd);
#ifdef XTI
	else if (xti) {
		if (!udp) {
			RelCon(conn_fd, &xti_info);
			t_close(conn_fd);
		}
	}
#endif /* XTI */
#endif
	if (!dtonly) {
		/*
		 * Include connection release.
		 */
		gettimeofday(&time2, NULL);
	}
	dt = time2.tv_sec - time0.tv_sec +
	     (time2.tv_usec - time0.tv_usec) * 1e-6;
	totdata += recdata;
	totmsg += recmsg;
	fthru = totdata / (dt * 1024.0);
	if (fthru < fthrumin)
		fthrumin = fthru;
	if (fthru > fthrumax)
		fthrumax = fthru;
	fmsg = totmsg / dt;
	if (fmsg > 0.0)
		fdelay = 1000.0 / fmsg;
	else
		fdelay = -1.0;

#ifdef SERVER

	tottt += rectt;
	if (totmsg > 0) {
		av_totdata = totdata / totmsg;
		av_tottt = 1000.0 * tottt / (float)totmsg;
	} else {
		av_totdata = -1;
		av_tottt = -1;
	}

	if (udp) {
		totudploss += udp_loss;		/* lost pkts of last period */
		if (verbose) {
			/* additional stats */
			sprintf(add_stats,
				"total_recv=%d msg/%d bytes total_lost=%d msg test_dur=%.3f",
				totmsg, totdata, totudploss, dt);
		} else {
			add_stats[0] = '\0';
		}

		if (mode == TT_MODE) {
			PRINT_OUT((stdout,
				"SERVER_SUMMARY %s conn %d RCV averTT=%.3f ms (minTT/maxTT=%.3f/%.3f ms) averM=%.1f msg/s averL=%.1f lost_msg/s %s\n",
				provider, connex,
				av_tottt, min_tt * 1000.0, max_tt * 1000.0,
				fmsg, (float)totudploss / dt,
				add_stats))
			tottt += rectt;
			rectt = 0.0;
		} else {
			/*
			 * throughput and RTT modes
			 */
			switch (units) {
			case MEGABITS_PER_SEC:
				sprintf(stats,
					"SERVER_SUMMARY %s conn %d RCV averT=%.3f Mbps (minT/maxT=%.3f/%.3f Mbps) averM=%.1f msg/s averD=%.3f ms averS=%.1f bytes/msg averL=%.1f lost_msg/s %s\n",
					provider, connex,
					fthru * 8.0 * 1024.0 * 1.0e-6,
					fthrumin  * 8.0 * 1024.0 * 1.0e-6,
					fthrumax  * 8.0 * 1024.0 * 1.0e-6,
					fmsg, fdelay, av_totdata,
					(float)totudploss / dt,
					add_stats);
				break;
			case KILOBYTES_PER_SEC:
			default:
				sprintf(stats,
					"SERVER_SUMMARY %s conn %d RCV averT=%.1f Kbytes/s (minT/maxT=%.1f/%.1f Kbytes/s) averM=%.1f msg/s averD=%.3f ms averS=%.1f bytes/msg averL=%.1f lost_msg/s %s\n",
					provider, connex,
					fthru, fthrumin, fthrumax, fmsg,
					fdelay, av_totdata,
					(float)totudploss / dt,
					add_stats);
				break;
			}
			totudploss = 0;
			udp_loss = 0;
		}

	} else if (tcp) {
		if (verbose) {
			/* additional stats */
			sprintf(add_stats,
				"total_recv=%d msg/%d Kbytes test_dur=%.3f s",
				totmsg, totdata, dt);
		} else {
			add_stats[0] = '\0';
		}
		switch (units) {
		case MEGABITS_PER_SEC:
			sprintf(stats,
				"SERVER_SUMMARY %s conn %d RCV averT=%.3f Mbps (minT/maxT=%.3f/%.3f Mbps) averM=%.1f msg/s averD=%.3f ms averS=%.1f bytes/msg %s\n",
				provider, connex,
				fthru   * 8.0 * 1024.0 * 1.0e-6,
				fthrumin  * 8.0 * 1024.0 * 1.0e-6,
				fthrumax  * 8.0 * 1024.0 * 1.0e-6,
				fmsg, fdelay, av_totdata, add_stats);
			break;
		case KILOBYTES_PER_SEC:
		default:
			sprintf(stats,
				"SERVER_SUMMARY %s conn %d RCV averT=%.1f Kbytes/s (minT/maxT=%.1f/%.1f Kbytes/s) averM=%.1f msg/s averD=%.3f ms averS=%.1f bytes/msg %s\n",
				provider, connex,
				fthru, fthrumin, fthrumax, fmsg,
				fdelay, av_totdata, add_stats);
			break;
		 }
	}

#else  /* CLIENT case */

	if (verbose) {
		/* additional stats */
		sprintf(add_stats, "total_snt=%d msg/%d bytes test_dur=%.3f s",
			totmsg, totdata, dt);
	} else {
		add_stats[0] = '\0';
	}
	switch (units) {
	case MEGABITS_PER_SEC:
		sprintf(stats,
			"CLIENT_SUMMARY %s conn %d %s averT=%.3f Mbps (minT/maxT=%.3f/%.3f Mbps) averM=%.1f msg/s averD=%.3f ms %s\n",
			provider, connex, (mode == RTT_MODE ? "SNDRCV" : "SND"),
			fthru * 8.0 * 1024.0 * 1.0e-6,
			fthrumin * 8.0 * 1024.0 * 1.0e-6,
			fthrumax * 8.0 * 1024.0 * 1.0e-6,
			fmsg, fdelay, add_stats);
		break;
	case KILOBYTES_PER_SEC:
	default:
		sprintf(stats,
			"CLIENT_SUMMARY %s conn %d %s averT=%.1f Kbytes/s (minT/maxT=%.1f/%.1f Kbytes/s) averM=%.1f msg/s averD=%.3f ms %s\n",
			provider, connex, (mode == RTT_MODE ? "SNDRCV" : "SND"),
			fthru, fthrumin, fthrumax, fmsg, fdelay, add_stats);
		break;
	}

#endif  /* SERVER/CLIENT */
	PRINT_OUT((stdout, "%s", stats))
}
