/* $Id: bench_var.c,v 1.4 1999/03/02 16:38:01 roca Exp $ */
/*
 * bench_var.c
 *
 *	Modified by : V.Roca
 *	Date	    : dec 1997
 *
 *	This file declares global variables and initialize them to their
 *	default value.
 */
/*
 * (c) Copyright 1998/1999 - V. Roca (vincent.roca@lip6.fr)
 * This tool is provided as is, without any warranty.
 * Permission to use, copy and modify is provided for non commercial
 * purposes as long as this notice appears on all copies.
 */

#include "bench.h"

int verbose = 0;
int raw = 0;			/* raw mode: arrival is recorded w/o stats */
int sock = 1;			/* use the Socket access method by default */
int xti = 0;
int tcp = 1;			/* use TCP by default */
int udp = 0;
int bcast = 0;
int mcast = 0;
int BSD_stack = 0;
int STREAMS_stack = 0;		/* stack identifier */
int mode = THRU_MODE;		/* test mode: throughput, rtt, tt ? */
int rt_pri = 0;			/* realtime mode: fixed priority */
int pin = 0;			/* realtime mode: pinned in memory */
int dont_fork = 0;		/* no fork (for debug purposes) */
int snd_version = 0;		/* t_snd version (xti only) */
int rcv_version = 0;		/* t_rcv version (xti only) */
int recbuf_size = DEF_RCVBUF_SIZE;	/* benchd's receive buffer size */
int sock_size = 0;		/* send/receive socket size */
int duration = 0;		/* test duration in seconds */
int rate = 0;			/* set rate controled sending */
int rate_interval = 0;		/* interval in us between two bursts */
int pkts_in_burst = 1;		/* number of packets in each burst */
int dtonly = 0;			/* do stats only during data transfer */
int nodelay = 0;		/* set the tcp nodelay option (for -rtt mode)*/
int push = 0;			/* set push flag in each t_sndseg() call */
#if defined(MTRACE) && defined(BOSX41)
int mtrace = 0;			/* start the instruction count tool */
#endif
int syncf = 0;			/* synchronize benchd with bench */
int cpustat = 0;		/* start the initstat tool for CPU usage */
int lockstat = 0;		/* start the lockstat tool */
int silent = 0;			/* silent mode: skip non PRINT_OUT */
int units = KILOBYTES_PER_SEC;	/* statistics unit */
#ifdef SERVER
int min_recdata = 10000000;	/* used for recv buffer length statistics */
int max_recdata = 0;		/* used for recv buffer length statistics */
float min_tt = 1000000.0;	/* transit time stats */
float max_tt = 0.0;		/* transit time stats */
#endif /* SERVER */

int eport = 0;

int tmsg = DEF_TIME_TRACE;
/*
 * recXXX are recorded statistics over a trace period
 */
int recdata = 0;
int recmsg = 0;
#ifdef SERVER
float rectt = 0.0;		/* recorded transit time during trace period */
#endif /* SERVER */
/*
 * totXXX are recorded statistics over the whole test duration
 */
int totdata = 0;
int totmsg = 0;
#ifdef SERVER
float tottt = 0.0;
int totudploss = 0;
#endif /* SERVER */

int connex = 0;
int conn_fd;
float fthrumin = 1000000.0;
float fthrumax = 0.0;
char rname[MAX_NAME_LEN] = "localhost";
struct in_addr raddr;
char servername[MAX_NAME_LEN] = "benchd";
char myport[5*MAX_NAME_LEN];
char provider[MAX_NAME_LEN];
struct timeval time0, time1, time2;
struct sockaddr_in sa;

#ifdef XTI
struct xtitp tp;
struct t_call *call;
struct t_unitdata *ud;
struct t_uderr *uderr;
#endif /* XTI */

/****** added... ******/
char *sndbuf;
int nbmsg = -1;
int lgthmsg = DEF_DATA_SIZE;
int con = 0, nbconn = 1;
int delay = 0;

#ifdef SERVER
char recbuf[MAX_RCVBUF_SIZE];	/* change in MAX_DATA_SIZE semantics */
int listen_fd;
struct sockaddr_in from;
struct sockaddr_in to;
int fromlen = sizeof(from);
/* int dchild; */
#ifdef FAST_SYNC
int fast_stop_done = 0;
#endif /* FAST_SYNC */
int udp_loss = 0;	/* was -1 ??? */
#endif /* SERVER */
u_short	udp_count = 0;	/* UDP packet counter; next pkt expected */

