/* $Id: chstksiz.c,v 1.2 1999/03/02 16:38:09 roca Exp $ */
/*
 * chstksiz.c
 */
/*
 * (c) Copyright 1998/1999 - V. Roca (vincent.roca@lip6.fr)
 * This tool is provided as is, without any warranty.
 * Permission to use, copy and modify is provided for non commercial
 * purposes as long as this notice appears on all copies.
 */

#if defined(BOSX32) || defined(BOSX41)

#include <errno.h>
#include <ulimit.h>
#include <sys/resource.h>

int
chstksiz (long	newsize)
{
	struct rlimit	rl;

	rl.rlim_max = rl.rlim_cur = newsize;
	return (setrlimit(RLIMIT_STACK, &rl));
}

#endif /* BOSX */
