#!/bin/sh
#
# $Id: net_eval.sh,v 1.3 1999/01/13 17:40:26 roca Exp $
#
# net_eval.sh
#
#	Created by  : V.Roca
#	Date	    : December 1998
#
#	Script used in association with bench for network
#	quality evaluation.
#	Created for the EDISON project.
#
#	NB: it requires that on the peer host two bench deamons run:
#		./benchd.OS_EXT -tcp -thru -p1968 &
#		./benchd.OS_EXT -udp -rtt -p1968 &
#

###### Constants : set accordingly ######

# In case you use extensions to distinguish various bench/benchd versions...
#BENCH_EXT='.linux'
#BENCH_EXT='.solaris'
BENCH_EXT='.linux'

# Bench repository
BENCH_DIR="$HOME/bin/"

# Message to add to trace file.
MSG=''

#DATE=`date +"%y.%W.%w_%HH%M"`
DATE=`date +"%y%b%d_%Hh%M"`

# If you want the trace file to be in the /tmp dir...
DIRRESULT='/tmp/net_eval/'

# Test duration. 20 seconds seems to be a good choice.
# This technique is better than the one consisting in
# limiting the number of messages!
THRU_DURATION=20
RTT_DURATION=120

# Rate for RTT raw mode
# Keep it small because the trace file size grows very quickly!
RATE_ARG='-rate10'

# Define the TSDU size of interest. It depends on the network interface
# you are using and its MTU (Max. Transmission Unit), on the precision
# you want to have. Having measure points at MSS, MSS+1 will create nice
# curves with sharp teeths.
# Edit as appropriate...
#
# Fast rendering: limit the number of samples.
#LMSG='16 100 250 500 1024 2048 4096'
LMSG='16 100 250 500 750 1024 1460'


###### Procedures ######

usage()
{
	echo "Usage: $0 <peerhost> [port] [rt]"
	exit 1
}


# run a cmd for a limited duration
# used for commands that would otherwise run indefinitely...
# param 1: cmd		XXX assumtion: it is osview
# param 2: duration
timedrun()
{
	$1 &
	sleep $2
	#
	# kill the cmd process.
	# Be carefull not to get confused with the awk process!
	# NB:	use "ps ax" with Linux, and "ps -e" with IRIX

	ps -e | awk '/osview/ { if ($4 == "osview") {print "kill -9 " $1} } END { printf "\n" }' | sh -s

	clear
}

# run the bench tool
# param 1: "thru" or "rtt"
benchrun()
{
	# Just to make sure that no page fault will occur !
	${BENCH_DIR}bench${BENCH_EXT} -help > /dev/null

	# Just to see if the machine is not too loaded
	# use vmstat if available, osview on IRIX otherwise
	#vmstat 3 5
	#timedrun osview 15 


	echo '================================================================================'
	# Format:
	#
	echo "Test date=$DATE host=$HOST peerhost=$PEERHOST system=$SYSTEM_$SYSTEM_VER"
	echo "$MSG"
	echo '================================================================================'

        case $1 in
        thru)

		# Throughput measures...

		echo '====== TCP Throughput Measures ======'
		for lmsg in $LMSG
		do
			echo "====== lmsg=$lmsg ======"
			echo "bench${BENCH_EXT} -h$PEERHOST $PORT_ARG -dtonly -silent -m120 $RT_ARG $CPUSTAT_ARG $SYNC_ARG -tcp -ssize32768 -thru -l$lmsg -dur$THRU_DURATION -V"
			${BENCH_DIR}bench${BENCH_EXT} -h$PEERHOST $PORT_ARG -dtonly -silent -m120 $RT_ARG $CPUSTAT_ARG $SYNC_ARG -tcp -ssize32768 -thru -l$lmsg -dur$THRU_DURATION -V
			echo '====== end bench ======'
			# security: consolidate the trace file.
			sync
			sleep 1
		done
		;;

	rtt)
		# RTT measures...

		echo '====== UDP RTT Measures ======'
		for lmsg in $LMSG
		do
			echo "====== lmsg=$lmsg ======"
			echo "bench${BENCH_EXT} -h$PEERHOST $PORT_ARG -silent -m120 $RT_ARG -udp -ssize32768 -rtt -l$lmsg -dur$RTT_DURATION -raw $RATE_ARG"
			${BENCH_DIR}bench${BENCH_EXT} -h$PEERHOST $PORT_ARG -silent -m120 $RT_ARG -udp -ssize32768 -rtt -l$lmsg -dur$RTT_DURATION -raw $RATE_ARG
			echo '====== end bench ======'
			# security: consolidate the trace file.
			sync
			sleep 1
		done
		;;

	esac
}


###### main ######

#
HOST=`uname -n`
SYSTEM=`uname -s`
SYSTEM_VER=`uname -r`		 # NB: Version must be a single word!

#
# Parameters parsing.
#
if [ $# -lt 1 ]
then
	echo "ERROR: too few arguments"
	usage
fi

PEERHOST="$1"

for param in "$@"
do
        case $param in
        port)
                PORT_ARG='-p1968'
                ;;
        rt)
                RT_ARG='-rt'
                ;;
	esac
done

# Create the result dir if required
if [ ! -d $DIRRESULT ]
then
	mkdir $DIRRESULT
fi

# ... and now test.
#
benchrun thru | tee $DIRRESULT/net_eval_$DATE.T
benchrun rtt | tee $DIRRESULT/net_eval_$DATE.RTT

# and compress the trace file...
# (replace compress by gzip (faster and more efficient) if available.
#
compress "$DIRRESULT/net_eval_$DATE.T" 
compress "$DIRRESULT/net_eval_$DATE.RTT" 

