/* $Id: bench_proto.h,v 1.5 1999/03/29 07:36:58 roca Exp $ */
/*
 * bench_proto.h
 *
 *	Modified by : V.Roca
 *	Date	    : dec 1997
 *
 *	bench/benchd function prototypes
 */
/*
 * Copyright (c) 1998/1999 - V.Roca (vincent.roca@lip6.fr) All rights reserved
 * This tool is provided as is, without any warranty.
 * Permission to use, copy and modify is provided for non commercial
 * purposes as long as this notice appears on all copies.
 */


#if defined(CPUSTAT) && defined(BOSX41)
/*
 * Functions defined in initstat.c and stopstat.c
 */
extern int  initstat();
extern int  stopstat();
#define TMPFILE	"/tmp/IoCpuStat"
#endif /* CPUSTAT && BOSX41 */


/*
 * common.c
 */

void ParseCommandLine (int argc, char *argv[]);
void PrintParams (void);
void Usage (int type, char *proc, int value);
void UsageHelp (char *proc);

/*
 * stats.c
 */

void PrintStartTime (int conn);
void PrintEndTime (int conn);
#ifdef SERVER
void ResetStats (void);
#endif /* SERVER */
void Stats (int	conn, int data, int msg, float tt);
void EndStats (void);
char * unit_transl (float value, int format);

#ifdef CLIENT

/*
 * bench.c
 */

/* void StartClient (int argc, char *argv[]); */
void StartClient (void);
void Client (int num);
void IntUser1 (void);
void IntUser2 (void);
void Interrupted (void);
void sync_start (void);
void sync_stop (void);

/*
 * bench_sock.c
 */

void SockOpen (int num);
void SockSendMsg (int num);
int  SockSelect (int fd, int sec, int husec);
int  SndbufMgmt (int fd, int op, int value);


#elif defined(SERVER)

/*
 * benchd.c
 */

void main (int argc, char *argv[]);
void Serve (int fd);
void DeathChild (void);
void Interrupted (void);
void IntUser1 (void);
void sync_setup (void);
void sync_start (void);
void sync_stop (void);

/*
 * benchd_sock.c
 */

void SockOpen (void);
int  SockAccept(void);
void SockRecvUDPMsg (void);
void SockRecvMsg (int fd);
int  RecvbufMgmt (int fd, int op, int val);

#endif
