/* $Id: bench_sock.c,v 1.9 1999/06/23 13:17:01 roca Exp $ */
/*
 * bench_sock.c
 *
 *	Modified by : V.Roca
 *	Date	    : dec 1997
 *
 *	Client part of the performance evaluation tool.
 *	Socket access method routines.
 */
/*
 * Copyright (c) 1998/1999 - V.Roca (vincent.roca@lip6.fr) All rights reserved
 * This tool is provided as is, without any warranty.
 * Permission to use, copy and modify is provided for non commercial
 * purposes as long as this notice appears on all copies.
 */

#include "bench.h"
#include "bench_proto.h"


void
SockOpen (int	num)
{
	struct hostent	*h;
	int		value;

	ASSERT(sock)
	memset((char *)&sa, 0, sizeof(sa));
	sa.sin_family = AF_INET;
	if (raddr.s_addr == 0) {
		/* user used the -h argument */
		if ((h = gethostbyname(rname)) == NULL) {
			PRINT_OUT((stdout, "bench: don't know remotename ""%s""\n", rname))
			EXIT(num, 1);
		}
		memcpy((char *)&sa.sin_addr.s_addr, h->h_addr_list[0], h->h_length);
		/* remember it as well */
		memcpy((char *)&raddr.s_addr, h->h_addr_list[0], h->h_length);
	} else {
		/* user used the -a argument */
		sa.sin_addr.s_addr = raddr.s_addr;
	}
	if (eport)
		sa.sin_port = htons(atoi(myport));
	else {
		struct servent *sp;

		if (!(sp = getservbyname(servername, "tcp"))) {
			PRINT_OUT((stdout, "bench: don't know server name ""%s""\n", servername))
			PRINT_OUT((stdout, "bench/benchd not registered in /etc/services or -p option forgotten\n"))
			EXIT(num, 1);
		}
		sa.sin_port = htons(sp->s_port);
	}
	PRINT_OUT((stdout, "CLIENT rem addr/port:	%s/%d\n", inet_ntoa(sa.sin_addr), sa.sin_port))

	if (tcp) {
		if ((conn_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
			perror("bench: socket");
			EXIT(num, 1);
		}
		if (nodelay) {
			int on = 1;
			if (setsockopt(conn_fd, IPPROTO_TCP, TCP_NODELAY,
				       (char*)&on, sizeof(on)) < 0) {
				perror("bench: setnodelayoption");
				EXIT(num, 1);
			}
		}
		if (sock_size > 0) {
			SndbufMgmt (conn_fd, SET_SOCKBUF, sock_size);
		}
		if (connect(conn_fd, (struct sockaddr*)&sa, sizeof(sa)) < 0) {
			perror("bench: connect");
			PRINT_ERR((stderr,
				"bench: check that server %s/tcp/%d is up\n",
				inet_ntoa(sa.sin_addr), sa.sin_port))
			EXIT(num, 1);
		}
	} else {	/* udp */
		if ((conn_fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
			perror("bench udp/bcast/mcast: socket");
			EXIT(num, 1);
		}

		if (bcast) {
			unsigned long t_net_type;
			int on = 1;

			if (setsockopt(conn_fd, SOL_SOCKET, SO_BROADCAST,
				       (char*)&on, sizeof(on)) < 0) {
				perror("bench bcast: setsockopt so_broadcast");
				EXIT(num, 1);
			}
			t_net_type = (unsigned long)sa.sin_addr.s_addr;
			t_net_type = (t_net_type >> 24);
			if (/*t_net_type >= 0 &&*/ t_net_type <= 126)
				sa.sin_addr = inet_makeaddr(inet_netof(sa.sin_addr), 0x00ffffff);
			else if (t_net_type >= 128 && t_net_type <= 191)
				sa.sin_addr = inet_makeaddr(inet_netof(sa.sin_addr), 0x0000ffff);
			else if (t_net_type >= 192 && t_net_type <= 223)
				sa.sin_addr = inet_makeaddr(inet_netof(sa.sin_addr), 0x000000ff);
			else {
				PRINT_ERR((stderr, "bench: bad network type\n"))
				EXIT(num, 1);
			}
			PRINT_OUT((stdout, "CLIENT bcast addr:\t%s\n",
				   inet_ntoa(sa.sin_addr)))
		} else if (mcast) {
			/* Nothing */
		}
		if (sock_size > 0) {
			SndbufMgmt (conn_fd, SET_SOCKBUF, sock_size);
		}
	}
	value = SndbufMgmt(conn_fd, GET_SOCKBUF, 0);
	PRINT_OUT((stdout, "CLIENT send socket :\t%d bytes for conn %d\n", value, num))
}


/*
 *	this is here that messages are sent if the socket api is used!
 */
void
SockSendMsg (int	num)
{
	int		i;
	int		sdata = 0;	/* init to 0 to prevent warning ! */
	int		rdata;
	/* u_short udp_count = 0; */	/* udp packet counter */
	int		res;		/* return value of select or poll */
	int		pkt = 0;	/* nb of packets already sent in burst*/
	struct timeval	send_time;	/* used in RTT/raw mode */
	struct timeval	recv_time;	/* used in RTT/raw mode */
	float		tt = 0.0;	/* rtt in RTT/raw mode, 0 otherwise */
	struct sockaddr_in tmp_sa;	/* temporary sockaddr used with udp */

	signal (SIGINT, (sighandler_t)Interrupted);
	
#ifdef FAST_SYNC
	if (udp) {
		/*
		 * inform the server immediately of the start of the udp test.
		 * not required with tcp since in that case opening of the
		 * connection is enough (and as efficient!).
		 */
		tmp_sa = sa;
		if ((sdata = sendto(conn_fd, START_MSG, START_STOP_MSG_SIZE, 0, (struct sockaddr*)&tmp_sa, sizeof(tmp_sa))) < 0) {
			perror("bench udp/bcast: sendto");
			exit(1);
		}
	}
#endif /* FAST_SYNC */
	PrintStartTime(num);

	gettimeofday(&time0, NULL);
	time1 = time0;
	for (i = 0 ; duration > 0 || nbmsg < 0 || i < nbmsg ; i++) {
		/*
		 * in case of rate control, wait a little bit
		 * between two bursts...
		 */
		if (rate) {
			if (pkt >= pkts_in_burst) {
				usleep(rate_interval);
				pkt = 0;
			}
			pkt++;
		}
#ifdef MTRACE
		/*
		 * do not start immediately. wait a while to be sure
		 * the working set is in memory and tcp in normal data
		 * transfer.
		 */
#define MTR_START	200
#define MTR_STOP	200
		if (mtrace && i == MTR_START)
			mtraceon();
#endif /* MTRACE */
		if (mode == RTT_MODE && raw) {
			/* we need a detailled evaluation of RTT */
			gettimeofday(&send_time, NULL);
		}
		if (udp) {
			/* udp packet numerotation */
			if (lgthmsg >= sizeof(u_short))
				*(u_short*)sndbuf = htons(udp_count++);
			errno = 0;
			if (mode == TT_MODE &&
			    lgthmsg >= sizeof(long) + sizeof(struct timeval)) {
				struct timeval	timestamp;
				/*
				 * need a timestamp; store it after the udp
				 * packet count plus two padding bytes for
				 * long word alignment
				 */
				/* gettimeofday((struct timeval*)(sndbuf + sizeof(long)), NULL); */
				gettimeofday(&timestamp, NULL);
				((struct timeval*)(sndbuf + sizeof(long)))->tv_sec
					= htonl(timestamp.tv_sec);
				((struct timeval*)(sndbuf + sizeof(long)))->tv_usec
					= htonl(timestamp.tv_usec);
			}
			tmp_sa = sa;
			if ((sdata = sendto(conn_fd, sndbuf, lgthmsg, 0, (struct sockaddr*)&tmp_sa, sizeof(tmp_sa))) < 0) {
				if (errno == ENOBUFS) {
					PRINT_ERR((stderr, "bench: sendto: enobufs\n"))
				} else {
					perror("bench udp/bcast: sendto");
					exit(1);
				}
				continue;
			}
		} else if (tcp) {
			if ((sdata = send(conn_fd, sndbuf, lgthmsg, 0)) < 0) {
				perror("bench: send");
				EXIT(num, 1);
			}
		}
		if (sdata != lgthmsg)
			PRINT_ERR((stderr,"bench: %d bytes sent instead of %d\n",
				sdata, lgthmsg))
#ifdef BOSX41
		cca_trchkl1t(cca_user_hkwd | bench_snd_end, sdata);
#endif

		if (mode == RTT_MODE) {
			int	remains;
			/*
			 * after each send, make sure we receive the same
			 * amount of data. do several recv if necessary.
			 */
			for (remains = sdata ; remains > 0 ; remains -= rdata) {
				if (udp) {
					int	fromlen = sizeof(tmp_sa);
					/*
					 * first need to be sure we
					 * won't wait for too long if
					 * an udp packet has been lost.
					 * wait at most 1 second.
					 */
					if ((res = SockSelect(conn_fd, 1, 0)) == 0) {
						perror("bench: timeout, udp packet lost");
						/* dont take lost packet
						 * into account for stats */
						gettimeofday(&time1, NULL);
						goto next_iteration;
					}
					if ((rdata = recvfrom(conn_fd, sndbuf, remains, 0, (struct sockaddr*)&tmp_sa, &fromlen)) < 0) {
						perror("bench: recvfrom");
						EXIT(num, 1);
					}
				} else {
					if ((rdata = recv(conn_fd, sndbuf, remains, 0)) < 0) {
						perror("bench: recv");
						EXIT(num, 1);
					}
				}
				if (raw) {
					gettimeofday(&recv_time, NULL);
					tt = (float)(recv_time.tv_sec - send_time.tv_sec) +
			     		     (float)(recv_time.tv_usec - send_time.tv_usec) * 1.0e-6;
				}
#ifdef BOSX41
				cca_trchkl1t(cca_user_hkwd | bench_rcv_end,
					     rdata);
#endif
			}
			/*
			 * in rtt mode, do not take received
			 * data into account for the statistics. it
			 * yields erroneous results.
			 */
		}
#ifdef MTRACE
		/*
		 * now stop.
		 */
		if (mtrace && i == mtr_stop)
			mtraceoff();
#endif /* MTRACE */
		/*
		 * limit the time of each test to "duration" seconds.
		 */
		gettimeofday(&time2, NULL);
		if (duration > 0) {
			/*
			 * this is a rough estimate since we should also
			 * take usec into account ! faster like that.
			 * add 1 second to compensate ;-)
			 */
			if (time2.tv_sec >= time0.tv_sec + duration + 1) {
				goto end_test;
			}
		}
		Stats(num, sdata, 1, tt);
next_iteration:
		;
	}

end_test:
	/* take the last packet sent into account (otherwise done in debit) */
	recdata += sdata;
	recmsg++ ;
#ifdef FAST_SYNC
	if (udp) {
		/*
		 * inform the server immediately of the end of the udp test.
		 * send several messages in case one of them is lost !!!
		 * (xxx: creates other pbs => avoid !)
		 * not required with tcp since in that case closing the
		 * connection is enough (and as efficient!).
		 */
		for (i=0; i< 1; i++) {
			tmp_sa = sa;
			if ((sdata = sendto(conn_fd, STOP_MSG, START_STOP_MSG_SIZE, 0, (struct sockaddr*)&tmp_sa, sizeof(tmp_sa))) < 0) {
				/* previous stop_msg has probably arrived */
				break;
			}
		}
	}
#endif /* FAST_SYNC */
	EndStats();
	PrintEndTime(num);
}


/*
 * SockSelect
 *
 * wait at most timeout for an event to arrive.
 *	- with socket api, use select,
 *	- with xti api, use poll.
 */
int
SockSelect (int	fd,
	    int	sec,
	    int	usec)
{
	int		res;
	fd_set		readmask;
	struct timeval	timeout;

	ASSERT(sock)

	FD_ZERO(&readmask);
	FD_SET(fd, &readmask);
	timeout.tv_sec = sec;
	timeout.tv_usec = usec;
	/* warning: 1st param must be fd+1, not 1! */
	if ((res = select(fd + 1, &readmask, (fd_set *)0, (fd_set *)0,
			  &timeout)) < 0) {
		perror("bench: select failed");
		EXIT(0, 1);
	}
	return(res);
}


/*
 * SndbufMgmt
 *
 * Sending socket buffer management function.
 * Returns the value set or read.
 */
int
SndbufMgmt (int	fd,
	    int	op,
	    int	val)
{
	int	err = 0;
	int	len = sizeof(val);

	if (op == SET_SOCKBUF)
		err = setsockopt(fd, SOL_SOCKET, SO_SNDBUF, (char*)&val, sizeof(val));
	else
		err = getsockopt(fd, SOL_SOCKET, SO_SNDBUF, (char*)&val, &len);
	if (err < 0) {
		perror("bench: SndbufMgmt");
		exit(1);
	}
	return val;
}
