/* $Id: common.c,v 1.12 2000/04/27 07:01:09 roca Exp $ */
/*
 * common.c
 *
 *	Modified by : V.Roca
 *	Date	    : dec 1997
 *
 *	bench/benchd common routines.
 */
/*
 * Copyright (c) 1998/1999 - V.Roca (vincent.roca@lip6.fr) All rights reserved
 * This tool is provided as is, without any warranty.
 * Permission to use, copy and modify is provided for non commercial
 * purposes as long as this notice appears on all copies.
 */

#include "bench.h"
#include "bench_proto.h"

#ifdef SOLARIS
extern char *optarg;
extern int getopt();
#endif


/****** parameter parsing ******/

void
ParseCommandLine (int	argc,
		  char	*argv[])
{
	int c;

	while ((c = getopt(argc, argv, "B:S:x:t:u:b:m:r:h:a:p:e:n:l:s:k:M:c:d:m:v:V")) != EOF) {
		switch (c) {
		case 'B':
			BSD_stack = 1;
			break;
		case 'S':
			STREAMS_stack = 1;
			break;
		case 'x':
#ifdef XTI
			if (!strcmp(optarg,"ti")) {
				xti = 1;
				sock = 0;
			} else {
#endif
				PRINT_ERR((stderr,
					"bad argument -x%s\n", optarg))
				Usage(argv[0]);
#ifdef XTI
			}
#endif
			break;
		case 't':
			if (!strcmp(optarg,"cp")) {
				tcp = 1;
				udp = 0;
			} else if (!strcmp(optarg,"hru")) {
				mode = THRU_MODE;
			} else if (!strcmp(optarg,"t")) {
				mode = TT_MODE;
			} else {
				PRINT_ERR((stderr,
					"bad argument -t%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 'u':
			if (!strcmp(optarg,"dp")) {
				udp = 1;
				tcp = 0;
			} else {
				PRINT_ERR((stderr,
					"bad argument -u%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 'b':
			if (!strcmp(optarg,"cast")) {
				bcast = 1;
				udp = 1;
			} else {
				PRINT_ERR((stderr,
					"bad argument -b%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 'r':
			if (!strcmp(optarg,"tt")) {
				mode = RTT_MODE;
			}
#if defined(LINUX) || defined(SOLARIS) || defined(BOSX41)
			else if (*optarg == 't') {
				if (isdigit(*(++optarg)))
					rt_pri = atoi(optarg);
				else
#ifdef SERVER
					rt_pri = BENCHD_PRI;
#else
					rt_pri = BENCH_PRI;
#endif
			}
#endif /* BOSX */
#ifdef CLIENT
			else if (*optarg == 'a' && *(optarg+1) == 't' &&
				 *(optarg+2) == 'e') {
				if (isdigit(*(optarg+3)))
					rate = atoi(optarg+3);
				else
					rate = 2;
				if (rate > 0) {
					/* Number of us between two sends */
					rate_interval = (int)(1000000.0 /
							      (float)rate);
					/*
					 * if we'd wait less than 20 ms, then
					 * use bursts instead
					 */
					if (rate_interval < 20000) {
						rate_interval = 20000;
						pkts_in_burst = (int) ceil((double)rate * (double)rate_interval * 1e-6);
						/* PRINT_OUT((stdout, "bench: high rate: bursts of %d packets every %d us\n", pkts_in_burst, rate_interval)) */
					} else
						pkts_in_burst = 1;
				} else {
					PRINT_ERR((stderr,
						"bad argument -r%s\n", optarg))
					Usage(argv[0]);
				}
			}
#endif /* CLIENT */
			else if (!strcmp(optarg,"aw")) {
				raw = 1;
			}
			else if (*optarg == 'b' && *(optarg+1) == 'u' &&
				 *(optarg+2) == 'f') {
				if (isdigit(*(optarg+3)))
					recbuf_size = atoi(optarg+3);
				if (recbuf_size <= 0 || recbuf_size > MAX_RCVBUF_SIZE) {
					PRINT_ERR((stderr,
					"benchd: rbuf value %d out of range ]%d; %d]\n",
					recbuf_size, 0, MAX_RCVBUF_SIZE))
					Usage(argv[0]);
				}
			}
			else {
				PRINT_ERR((stderr,"bad argument -r%s\n",optarg))
				Usage(argv[0]);
			}
			break;
		case 'h':
			if (!strcmp(optarg,"elp"))
				UsageHelp(argv[0]);
			else {
				if (*optarg == 'o' && *(optarg+1) == 's' &&
					*(optarg+2) == 't')
					strcpy(rname, optarg+3);
				else
					strcpy(rname, optarg);
				break;
			}
		case 'a':
			if (*optarg == 'd' && *(optarg+1) == 'd' &&
				 *(optarg+2) == 'r' && isdigit(*(optarg+3))) {
				if(( raddr.s_addr = inet_addr((char *)optarg+3)) == -1) {
        				PRINT_ERR((stderr,
					"invalid IP address %s\n", optarg+3))
					Usage(argv[0]);
				}
			} else if (isdigit(*optarg)) {
				if(( raddr.s_addr = inet_addr((char *)optarg)) == -1) {
        				PRINT_ERR((stderr,
					"invalid IP address %s\n", optarg))
					Usage(argv[0]);
				}
			} else {
				PRINT_ERR((stderr,"bad argument -a%s\n",optarg))
				Usage(argv[0]);
			}
			break;
		case 'p':
			if (isdigit(*optarg)) {
				strcpy(myport, optarg);
				eport++;
			}
#if defined(LINUX) || defined(SOLARIS) || defined(BOSX41)
			else if (!strcmp(optarg,"in"))
				pin = 1;
#endif /* BOSX */
			else if (!strcmp(optarg,"ush"))
				push = 1;
			else {
				PRINT_ERR((stderr, "bad argument -p%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 'e':
			strcpy(servername, optarg);
			break;
		case 'n':
			if (!strcmp(optarg,"odelay"))
				nodelay = 1;
#ifdef SERVER
			else if (!strcmp(optarg,"ofork"))
				dont_fork++;
#endif /* SERVER */
#ifdef CLIENT
			else if (isdigit(*optarg))
				nbmsg = atoi(optarg);
#endif /* CLIENT */
			else {
				PRINT_ERR((stderr, "bad argument -n%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 'l':
#ifdef BOSX41
			if (!strcmp(optarg,"ockstat"))
				lockstat = 1;
			else
#endif /* BOSX41 */
#ifdef CLIENT
			if (isdigit(*optarg)) {
				lgthmsg = atoi(optarg);
				if (lgthmsg <= 0 || lgthmsg > MAX_DATA_SIZE) {
					PRINT_ERR((stderr,
						"bad length %d, max %d\n",
						lgthmsg, MAX_DATA_SIZE))
					Usage(argv[0]);
				}
			} else
#endif /* CLIENT */
			{
				PRINT_ERR((stderr, "bad argument -l%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 's':
			if (!strcmp(optarg,"ock")) {
				sock = 1;
				xti = 0;
			} else if (!strcmp(optarg,"ilent"))
				silent = 1;
			else if (!strcmp(optarg,"ync"))
				syncf = 1;
			else if (*optarg == 's' && *(optarg+1) == 'i' &&
				 *(optarg+2) == 'z' && *(optarg+3) == 'e' &&
				isdigit(*(optarg+4))) {
				sock_size = atoi(optarg+4);
			} else {
				PRINT_ERR((stderr, "bad argument -s%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 'k':
			if (*optarg == 'B')
				units = KILOBYTES_PER_SEC;
			else if (*optarg == 'b')
				units = KILOBITS_PER_SEC;
			else {
				PRINT_ERR((stderr, "bad argument -k%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 'M':
#ifdef NOT_YET
			if (*optarg == 'B')
				units = MEGABYTES_PER_SEC;
			else
#endif /* NOT_YET */
			if (*optarg == 'b')
				units = MEGABITS_PER_SEC;
			else {
				PRINT_ERR((stderr, "bad argument -k%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 'c':
			if (!strcmp(optarg,"pustat1"))
				cpustat = 1;	/* use sar */
#if defined(CPUSTAT) && defined(BOSX41)
			else if (!strcmp(optarg,"pustat2"))
				cpustat = 2;	/* use initstat */
#endif /* CPUSTAT && BOSX41 */
			else if (!strcmp(optarg,"pustat3"))
				cpustat = 3;	/* use vmstat */
			else if (isdigit(*optarg)) {
				nbconn = atoi(optarg);
				if (nbconn < 1 || nbconn > MAX_CONNECT) {
					PRINT_ERR((stderr,
						"bad connect nb %d, max %d\n",
						nbconn, MAX_CONNECT))
					Usage(argv[0]);
				}
				con++;
			} else {
				PRINT_ERR((stderr, "bad argument -c%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 'd':
			if (isdigit(*optarg))
				delay = atoi(optarg);
			else if (!strcmp(optarg,"tonly"))
				dtonly = 1;
#ifdef CLIENT
			else if (*optarg == 'u' && *(optarg+1) == 'r') {
				if (isdigit(*(optarg+2)))
					duration = atoi(optarg+2);
				if (duration <= 0) {
					PRINT_ERR((stderr, "bad argument -d%s\n", optarg))
					Usage(argv[0]);
				}
			}
#endif /* CLIENT */
			else {
				PRINT_ERR((stderr, "bad argument -d%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 'm':
			if (!strcmp(optarg,"mcast")) {
				mcast = 1;
				udp = 1;
			} else
#if defined(MTRACE) && defined(BOSX41)
			if (!strcmp(optarg,"trace")) {
				mtrace = 1;
			} else
#endif /* MTRACE && BOSX41 */
			if (isdigit(*optarg)) {
				tmsg = atoi(optarg);
				if (tmsg <= 0)
					tmsg = DEF_TIME_TRACE;
			} else {
				PRINT_ERR((stderr, "bad argument -m%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 'v':
			if (*optarg == 'e' && *(optarg+1) == 'r'
			    && isdigit(*(optarg+2))) {
				int version = *(optarg+2);

				if (version == 0 || version == 1)
					snd_version = version;
				else if (version == 3 || version == 4)
					rcv_version = version;
				else {
					PRINT_ERR((stderr, "bad argument -v%s\n", optarg))
					Usage(argv[0]);
				}
			} else {
				PRINT_ERR((stderr, "bad argument -v%s\n", optarg))
				Usage(argv[0]);
			}
			break;
		case 'V':
			verbose = 1;
			break;
		default:
			/*
			 * NB: getopt returns '?' when finding an
			 * unknown argument; avoid the following
			 * error msg in that case
			 */
			if (c != '?')
				PRINT_ERR((stderr, "bad argument %c\n", c))
			Usage(argv[0]);
			break;
		}
	}

	if (tcp + udp != 1) {
		PRINT_ERR((stderr, "specify exactly one protocol\n"))
		Usage(argv[0]);
	}

	if (mode == RTT_MODE && (bcast || mcast)) {
		PRINT_ERR((stderr, "rtt not valid with bcast\n"))
		Usage(argv[0]);
	}

	if (mode == TT_MODE && tcp) {
		PRINT_ERR((stderr, "tt only valid with udp\n"))
		Usage(argv[0]);
	}

#ifdef CLIENT
	if (con && (udp || bcast || mcast)) {
		PRINT_ERR((stderr, "connections not valid with udp or bcast\n"))
		Usage(argv[0]);
	}
	
	if (delay && nbconn <= 1) {
		PRINT_ERR((stderr, "delay require more several connections\n"))
		Usage(argv[0]);
	}
#endif /* CLIENT */

	if (eport && !(tcp || udp)) {
		PRINT_ERR((stderr, "port number requires tcp or udp\n"))
		Usage(argv[0]);
	}

	if (BSD_stack + STREAMS_stack > 1) {
		PRINT_ERR((stderr, "at most one stack\n"))
		Usage(argv[0]);
	}

	if (sock + xti != 1) {
		PRINT_ERR((stderr, "at most one access method\n"))
		Usage(argv[0]);
	}

	if (nodelay && !tcp) {
		PRINT_ERR((stderr, "nodelay only valid with tcp\n"))
		Usage(argv[0]);
	}

#ifdef CLIENT
	if (nbmsg >= 0 && duration > 0) {
		PRINT_ERR((stderr, "-nN and -durD are mutually exclusive\n"))
		Usage(argv[0]);
	}

#ifdef FAST_SYNC
	if (lgthmsg == START_STOP_MSG_SIZE) {
		PRINT_ERR((stderr, "non authorized size %d (used by START/STOP sync messages)\n", lgthmsg))
		Usage(argv[0]);
	}
#endif /* FAST_SYNC */
#endif /* CLIENT */
}


void
PrintParams (void)
{
	int i;
#if defined(CLIENT)
#define SIDE	"CLIENT"
#elif defined(SERVER)
#define SIDE	"SERVER"
#elif
#endif

#ifdef XTI
	if (xti) {
		if (BSD_stack) {
			if (udp) {
				tp.tp_id = TPID_UDP;
				strcpy(provider, "BSD udp");
			}
			else if (tcp) {
				tp.tp_id = TPID_TCP;
				strcpy(provider, "BSD tcp");
			}
		} else if (STD_stack) {
			if (udp) {
				tp.tp_id = TPID_STD_UDP;
				strcpy(provider, "STD udp");
			}
			else if (tcp) {
				tp.tp_id = TPID_STD_TCP;
				strcpy(provider, "STD tcp");
			}
		}
		else if (tcp) {
			tp.tp_id = TPID_TCP;
#ifdef TLI
			strcpy(provider, "tli tcp");
#else
			strcpy(provider, "xti tcp");
#endif
		}

		if (t_gettp(&tp) < 0) {
			t_error_ns("t_gettp failed");
			exit(1);
		}
	} else
#endif /* XTI */
	if (sock) {
#ifdef NOT_YET
		if (BSD_stack) {
			if (tcp)
				strcpy(provider, "BSD tcp");
			else if (udp)
				strcpy(provider, "BSD udp");
			else
				strcpy(provider, "BSD bcast");
		}
#else  /* NOT_YET */
		if (tcp)
			strcpy(provider, "tcp");
		else if (udp)
			strcpy(provider, "udp");
		else if (bcast)
			strcpy(provider, "bcast");
		else if (mcast)
			strcpy(provider, "mcast");
#endif /* NOT_YET */
	}

	sndbuf = (char *)malloc(lgthmsg);
	for (i = 0 ; i < lgthmsg ; i++)
		sndbuf[i] = (char)i;

#if defined(LINUX) || defined(SOLARIS)
	/*
	 * NB: we can set real-time properties here since it is
	 * inherited across a fork.
	 * But this is not the case of memory locking (done in bench[d].c) !
	 */
	if (rt_pri > 0) {
		/* Change to a fixed real-time priority */
		struct sched_param	sp;

		sp.sched_priority = rt_pri;
		if (sched_setscheduler(0, SCHED_FIFO, &sp) < 0) {
			perror("bench: sched_setscheduler");
			printf("bench: errno=%d\n", errno);
			exit(-1);
		}
	}
#elif defined(BOSX41)
	if (rt_pri > 0) {
		/* Change to a fixed real-time priority */
		if (setpri(getpid(), rt_pri) < 0) {
			perror("bench: setpri");
			exit(-1);
		}
	}
	if (pin > 0) {
		/* shrink stack to pinnable size */
		if (chstksiz(BENCH_STKSIZ) < 0) {
			perror("bench: chstksiz");
			exit(-1);
		}
		/* pin text and data segs to memory */
		if (plock(PROCLOCK) < 0) {
			perror("bench: plock");
			exit(-1);
		}
	}
#endif /* BOSX */

	if (mode == RTT_MODE)
		PRINT_OUT((stdout, "%s mode :\t\trtt\n", SIDE))
	else if (mode == TT_MODE)
		PRINT_OUT((stdout, "%s mode :\t\ttransit time\n", SIDE))
	else
		PRINT_OUT((stdout, "%s mode :\t\tthroughput\n", SIDE))
	PRINT_OUT((stdout, "%s provider :\t%s\n", SIDE, provider))
	if (sock)
		PRINT_OUT((stdout, "%s api :\t\tsocket\n", SIDE))
#ifdef XTI
	else if (xti)
		PRINT_OUT((stdout, "%s api :\t\txti\n", SIDE))
	if (xti) {
		switch (snd_version) {
		case 0:
			PRINT_OUT((stdout, "%s snd version :\t0 - original t_snd\n", SIDE))
			break;
		case 1:
			PRINT_OUT((stdout, "%s snd version :\t1 - use write directly\n", SIDE))
			break;
		}
		switch (rcv_version) {
		case 0:
			PRINT_OUT((stdout, "%s rcv version :\t0 - original t_rcv\n", SIDE))
			break;
		case 1:
			PRINT_OUT((stdout, "%s rcv version :\t1 - t_rcv1 based on read\n", SIDE))
			break;
		}
	}
#endif /* XTI */
#ifdef CLIENT
	if (rate)
		PRINT_OUT((stdout, "%s send rate :\t%d Msg/s (theory), %d pkts in burst, %d us interval\n",
			   SIDE, rate, pkts_in_burst, rate_interval))
#endif /* CLIENT */
	if (rt_pri > 0)
		PRINT_OUT((stdout, "%s real-time mode :\tpri=%d\n",
			   SIDE, rt_pri))
	if (raddr.s_addr != 0)
		PRINT_OUT((stdout, "%s address :\t%s\n", SIDE, inet_ntoa(raddr)))
#ifdef CLIENT	/* because a server won't use any hostname */
	else
		PRINT_OUT((stdout, "%s remote host :\t%s\n", SIDE, rname))
#endif /* CLIENT */
	if (eport)
		PRINT_OUT((stdout, "%s port number :\t%s\n", SIDE, myport))
	else
		PRINT_OUT((stdout, "%s port number :\tname server\n", SIDE))
#ifdef CLIENT
	PRINT_OUT((stdout, "%s server name :\t%s\n", SIDE, servername))
	if (nbmsg >= 0)
		PRINT_OUT((stdout, "%s nb of msg :\t%d\n", SIDE, nbmsg))
	else if (duration > 0)
		PRINT_OUT((stdout, "%s test duration :\t%d seconds\n",
			   SIDE, duration))
	else
		PRINT_OUT((stdout, "%s nb of msg :\tinfinite\n", SIDE))
	PRINT_OUT((stdout, "%s length of msg :\t%d\n", SIDE, lgthmsg))
	if (!udp && !bcast && !mcast)
		PRINT_OUT((stdout, "%s nb of connect :\t%d\n", SIDE, nbconn))
	/*
	 * if (nbconn > 1)
	 * 	PRINT_OUT((stdout, "%s connect delay :\t%d ms\n", SIDE, delay))
	 */
#endif /* CLIENT */

#ifdef SERVER
	PRINT_OUT((stdout, "%s recv buffer :\t%d bytes\n", SIDE, recbuf_size))
#else  /* SERVER */
	if (mode == RTT_MODE)
		PRINT_OUT((stdout, "%s recv buffer :\t%d bytes\n", SIDE,
			   recbuf_size))
#endif /* SERVER */
	if (!raw) {
		switch (units) {
		case MEGABITS_PER_SEC:
			PRINT_OUT((stdout,
			"%s units :\t\tMbps (10^6 bits per second)\n", SIDE))
			break;
		case KILOBITS_PER_SEC:
			PRINT_OUT((stdout,
			"%s units :\t\tkbps (10^3 bits per second)\n", SIDE))
			break;
		default:
			PRINT_OUT((stdout,
			"%s units :\t\tkBps (1024 bytes per second)\n", SIDE))
			break;
		}
	}
	if (raw) {
		PRINT_OUT((stdout, "\n--------------------------------------------------------------------------------\n"))
#ifdef SERVER
		if (udp) {
			PRINT_OUT((stdout, "timestamp(s)\t\tSize(bytes) Message_sequence_nb Transit_Time(ms) Lost_messages/s\n"))
		} else {
			PRINT_OUT((stdout, "timestamp(s)\t\tSize(bytes)\n"))
		}
#else  /* CLIENT case */
		if (udp) {
			PRINT_OUT((stdout, "timestamp(s)\t\tSize(bytes) Message_sequence_nb Transit_Time(ms)\n"))
		} else {
			PRINT_OUT((stdout, "timestamp(s)\t\tSize(bytes) Transit_Time(ms)\n"))
		}
#endif /* SERVER/CLIENT */
	} else
		PRINT_OUT((stdout, "%s trace period :\t%d seconds\n", SIDE, tmsg))
}


/****** usage ******/

/*
 *	Short error message.
 */
void
Usage  (char		*proc)
{
	PRINT_ERR((stderr, "Use %s -help for usage\n", proc))
	exit(1);
}


/*
 *	Complete usage message.
 */
void
UsageHelp  (char	*proc)
{
	PRINT_OUT((stdout, "\nNetwork performance evaluation environment\n"))

	/* Edit version number as appropriate... */
	PRINT_OUT((stdout, "Version 0.92.6 - vincent.roca@lip6.fr\n\n"))

	PRINT_OUT((stdout, "%s usage:\n", proc))
	PRINT_OUT((stdout, "	-help	print this page\n"))

	/******/
	PRINT_OUT((stdout, "  Test type:\n"))
	PRINT_OUT((stdout, "	-thru	set Throughput mode (default)\n"))
	PRINT_OUT((stdout, "	-rtt	set Round Trip Time mode\n"))
	PRINT_OUT((stdout, "	-tt	set Transit Time mode (requires udp)\n"))

	/******/
	PRINT_OUT((stdout, "  Stack, protocol, and access method:\n"))
	PRINT_OUT((stdout, "	-sock	use Socket access method (default)\n"))
#ifdef XTI
	PRINT_OUT((stdout, "	-xti	use XTI (X/Open Transport Library) access method\n"))
	PRINT_OUT((stdout, "		not yet supported...\n"))
#endif	/* XTI */
	PRINT_OUT((stdout, "	-tcp	use tcp (default)\n"))
	PRINT_OUT((stdout, "	-udp	use udp \n"))
	PRINT_OUT((stdout, "	-bcast	use udp in broadcast mode\n"))
	PRINT_OUT((stdout, "		not yet supported...\n"))
	PRINT_OUT((stdout, "	-mcast	use udp in multicast mode\n"))
	PRINT_OUT((stdout, "		not yet supported...\n"))
#ifdef NOT_YET
	PRINT_OUT((stdout, "	-BSD	use BSD stack\n"))
	PRINT_OUT((stdout, "	-STREAMS use STREAMS stack\n"))
	PRINT_OUT((stdout, "		(BSD and STREAMS options are for unfrequent systems\n"))
	PRINT_OUT((stdout, "		 with several stacks available)\n"))
	PRINT_OUT((stdout, "		Not yet supported...\n"))
#endif /* NOT_YET */

	/******/
	PRINT_OUT((stdout, "  Test parameters:\n"))
#ifdef CLIENT
	PRINT_OUT((stdout, "	-h[ost]H set remote host to H (name or dotted address) to H\n"))
	PRINT_OUT((stdout, "		(default is ""localhost""/127.0.0.1)\n"))
	PRINT_OUT((stdout, "	-a[ddr]A set remote [uni/broad/multi]cast dotted address to A\n"))
	PRINT_OUT((stdout, "		(mutually exclusive with -hH)\n"))
#else /* SERVER */
	PRINT_OUT((stdout, "	-addrA	set remote [uni/broad/multi]cast address to A\n"))
#endif /* CLIENT */
	PRINT_OUT((stdout, "	-pP	set port number to P (valid with tcp or udp)\n"))
	PRINT_OUT((stdout, "		(by default, use getserv... functions and /etc/services file)\n"))
#ifdef CLIENT
	PRINT_OUT((stdout, "	-eE	set server name to E (default is ""benchd"")\n"))
	PRINT_OUT((stdout, "	-nN	set the number of msg sent to N (default is infinite)\n"))
	PRINT_OUT((stdout, "	-durD	set the duration of test to D seconds (mut. exclusive with -nN)\n"))
	PRINT_OUT((stdout, "	-lL	set the length of msg sent to L (default is %d bytes)\n", DEF_DATA_SIZE))
	PRINT_OUT((stdout, "	-cC	set the number of connections to C (not valid with\n"))
	PRINT_OUT((stdout, "		udp and bcast) (default is 1)\n"))
	PRINT_OUT((stdout, "	-dD	set delay in seconds between connections requests\n"))
	PRINT_OUT((stdout, "		(valid if C != 1) (default is no delay)\n"))
#endif /* CLIENT */

	/******/
	PRINT_OUT((stdout, "  Units:\n"))
	PRINT_OUT((stdout, "	-kB	results in kilobytes/s (1024) (default)\n"))
	PRINT_OUT((stdout, "	-Mb	results in megabits/s (10^6)\n"))
	PRINT_OUT((stdout, "	-kb	results in kilobits/s (10^3)\n"))
#ifdef NOT_YET
	PRINT_OUT((stdout, "	-MB	results in megabytes/s (10^6)\n"))
#endif /* NOT_YET */

	/******/
	PRINT_OUT((stdout, "  Various options:\n"))
	PRINT_OUT((stdout, "	-raw	raw mode: no stats, print each pkt\n"))
	PRINT_OUT((stdout, "	-V	verbose mode for more stats\n"))
	PRINT_OUT((stdout, "	-sync	synchronize benchd with bench\n"))
	PRINT_OUT((stdout, "	-nodelay set nodelay option of tcp on (default is off)\n"))
#if defined(LINUX)
	PRINT_OUT((stdout, "	-rtR	use real-time process of priority R (must be root)\n"))
#ifdef SERVER
	PRINT_OUT((stdout, "		(default %d)\n", BENCHD_PRI))
#else
	PRINT_OUT((stdout, "		(default %d)\n", BENCH_PRI))
#endif
	PRINT_OUT((stdout, "	-pin	pin code and data in memory\n"))
#elif defined(BOSX41)
	PRINT_OUT((stdout, "	-rtR	use real-time process of priority R (must be root)\n"))
	PRINT_OUT((stdout, "		(default %d)\n", BENCH_PRI))
	PRINT_OUT((stdout, "	-pin	pin code and data in memory\n"))
#endif /* BOSX */
	PRINT_OUT((stdout, "	-rateR	set sending rate to R msg/s\n"))
	PRINT_OUT((stdout, "		(default value if R not mentioned: 2 msg/s)\n"))
	PRINT_OUT((stdout, "	-silent	silent mode\n"))
#ifdef SERVER
	PRINT_OUT((stdout, "	-nofork	don't fork (for debug)\n"))
#endif /* SERVER */
	PRINT_OUT((stdout, "	-mM	print trace reports every M seconds (default is %d)\n", DEF_TIME_TRACE))
	PRINT_OUT((stdout, "	-dtonly	print trace reports during data transfer only\n"))
	PRINT_OUT((stdout, "		(i.e. w/o conn setup and release)\n"))
#ifdef XTI
	PRINT_OUT((stdout, "	-vern	use send version n:\n"))
	PRINT_OUT((stdout, "			0: use send (Socket) or t_snd (XTI)(default)\n"))
	PRINT_OUT((stdout, "			1: use write directly\n"))
	PRINT_OUT((stdout, "		use receive version n (rtt mode):\n"))
	PRINT_OUT((stdout, "			3: use recv (Socket) or t_rcv (XTI) (default)\n"))
	PRINT_OUT((stdout, "			4: use read directly\n"))
#endif /* XTI */
	PRINT_OUT((stdout, "	-rbufR	set receive buffer to R bytes (default is %d)\n", DEF_RCVBUF_SIZE))
	PRINT_OUT((stdout, "	-ssizeR set receive/send socket sizes to R bytes\n"))
#if defined(MTRACE) && defined(BOSX41)
	PRINT_OUT((stdout, "	-mtrace	start the instruction count tool\n"))
#endif /* MTRACE && BOSX41 */
	PRINT_OUT((stdout, "	-cpustat1 use the sar tool for CPU usage\n"))
#if defined(CPUSTAT) && defined(BOSX41)
	PRINT_OUT((stdout, "	-cpustat2 use the initstat tool for CPU usage\n"))
#endif /* CPUSTAT && BOSX41 */
	PRINT_OUT((stdout, "	-cpustat3 use the vmstat tool for CPU usage\n"))
#ifdef BOSX41
	PRINT_OUT((stdout, "	-lockstat use the lockstat tool\n"))
#endif /* BOSX41 */
	exit(1);
}
