#!/bin/sh
#
# $Id: highlow_recv.sh,v 1.1 1999/05/26 15:20:39 roca Exp $
#
# highlow_recv.sh
#
#	Created by  : V.Roca
#	Date	    : May 1999
#
#	Script used in association with bench for network
#	quality evaluation.
#	Created for the EDISON project.
#
#	This is the reception side.
#

###### Constants : set accordingly ######

# In case you use extensions to distinguish various bench/benchd versions...
#BENCH_EXT='.linux'
BENCH_EXT='.solaris'
#BENCH_EXT='.irix'

# Bench repository
#BENCH_DIR="$HOME/bin/"
BENCH_DIR="/comptes/roca/bench/bench_v0.92.5/bench/"

# And now the tools...
BENCH="${BENCH_DIR}bench${BENCH_EXT}"
BENCHD="${BENCH_DIR}benchd${BENCH_EXT}"

# Message to add to trace file.
MSG=''

#DATE=`date +"%y.%W.%w_%HH%M"`
DATE=`date +"%y%b%d_%Hh%M"`

# If you want the trace file to be in the /tmp dir...
DIRRESULT='/tmp/cisco_tests/'

# scenario for low prio flow (in seconds)
#WAIT_TO_START=120
#WAIT_TO_START=30
#DURATION=180
#DURATION=60
# scenario for high prio flow (in seconds)
#DURATION_PRIO=600
#DURATION_PRIO=120

# (Theoritical!) Sending rates (in pkts/s)
#RATE='500'
#RATE_PRIO='100'

# Port numbers
PORT='-p30000' 
PORT_PRIO='-p10000'

# Define the TSDU size of interest. It depends on the network interface
# you are using and its MTU (Max. Transmission Unit), on the precision
# you want to have. Having measure points at MSS, MSS+1 will create nice
# curves with sharp teeths.
# Edit as appropriate...
#
# Fast rendering: limit the number of samples.
#LMSG='16 100 250 500 750 1024 1460'
LMSG=1024

###### Procedures ######

usage()
{
	echo "Usage: $0 [high|low]"
	echo "	high|low	store high or low priority data flows stats in a file"
	exit 1
}


# run a cmd for a limited duration
# used for commands that would otherwise run indefinitely...
# param 1: cmd		XXX assumtion: it is osview
# param 2: duration
timedrun()
{
	$1 &
	sleep $2
	#
	# kill the cmd process.
	# Be carefull not to get confused with the awk process!
	# NB:	use "ps ax" with Linux, and "ps -e" with IRIX

	ps -e | awk '/osview/ { if ($4 == "osview") {print "kill -9 " $1} } END { printf "\n" }' | sh -s

	clear
}


# run the bench tool
benchrun()
{
	# Just to make sure that no page fault will occur !
	${BENCH} -help > /dev/null

	echo '================================================================================'
	echo "Test date=$DATE host=$HOST peerhost=$PEERHOST system=$SYSTEM_$SYSTEM_VER"
	echo "$MSG"
	echo '================================================================================'

	case $FLOW in
	high)
		# high prio flow (RTT measures)
		echo '====== UDP throughput Measures : high priority ======'
		echo "${BENCHD} $PORT_PRIO -udp -rtt -ssize32768"
		${BENCHD} $PORT_PRIO -udp -rtt -ssize32768
		echo '====== end bench ======'
		;;

	low)
		# low prio flow (throughput)
		echo '====== UDP throughput Measures : low priority ======'
		echo "${BENCHD} $PORT -udp -silent -m1 -ssize32768 -sync"
		${BENCHD} $PORT -udp -silent -m1 -ssize32768 -sync
		echo '====== end bench ======'
		;;

	esac
}


###### main ######

#
HOST=`uname -n`
SYSTEM=`uname -s`
SYSTEM_VER=`uname -r`		 # NB: Version must be a single word!

#
# Parameters parsing.
#
if [ $# -lt 1 ]
then
	echo "ERROR: too few arguments"
	usage
fi

FLOW="$1"

# Create the result dir if required
if [ ! -d $DIRRESULT ]
then
	mkdir $DIRRESULT
	chmod ugo+rwx $DIRRESULT
fi

# ... and now test.
#
case $FLOW in
high)
	# no trace generated in rtt mode!
	#benchrun | tee $DIRRESULT/high_recv_$DATE.RTT
	benchrun
	;;
low)
	#benchrun | tee $DIRRESULT/low_recv_$DATE.T
	benchrun > $DIRRESULT/low_recv_$DATE.T
	;;
esac

# and compress the trace file...
# (replace compress by gzip (faster and more efficient) if available.
#
# compress "$DIRRESULT/testprio_$DATE.RTT" 

