#!/bin/sh
#
# $Id$
#
# bsort.inst_T
#
#	Created on  : 04/12/98
#	Author	    : V. Roca
#
#	Analysis of the instantaneous throughput (rather than the summary).
#	Parses the data file generated by benchd and generates data and
#	dem files to be used by gnuplot.

# (c) Copyright 1998 - VR: this tool is provided as is, without any
# warranty.
# Permission to use, copy and modify is provided for non commercial
# purposes as long as this notice appears on all copies.

#
# Parse a raw benchd file and create a single sortfile file.
#
#	The format of bencht file is a list of:
#
#		Header generated by bencht (see below for format).
#		Then for each TSDU length, a list of:
#			Header generated by benchd.
#			Raw traces of benchd.
#
# WARNING: on Solaris, use nawk, on Linux use awk !
awk '
	#
	# Search in record rec the string str and return the value
	# that follows the = char.
	#
	function getval(rec,str) {
		n=split(rec,A,str);
		if (n<2) {
			printf ("gnusort: ERROR, string %s not found in %s\n",
				str,rec);
			exit;
		}
		n=split(A[2],B,"=");
		if (n<2) {
			printf("gnusort: ERROR, char = not found in %s\n",
				str,rec);
			exit;
		}
		return B[2];
	}
	BEGIN {
		count  = 0;		# number of curves
		cumulT = 0.0;		# cumulative throughput over
					# the connections
		nbcumul = 0;		# number of connections
		style  = "with linespoints";
	}
	END {
		# Record the number of curves to plot.
		# This is the only way to pass the info to the shell.
		#
		print "count " count
	}
	/Test/ {
		#
		# Parse the fixed-size control part generated by bencht.
		# Format and fields (example):
		#	Test co_bench date: 436.1_11H00 \
		#		$2		$4
		#	Host: etna01 Peerhost: localhost \
		#		$6		$8
		#	System: AIX 9438A_up-UP Provider: CCA.tcp
		#		$10	$11		   $13
		#	API: xti.t_sndseg Fork: 1 CPU: 1
		#		$15	       $17    $19
		#

		appli = $2;
#		date = $4;
#		host = $6;
#		peerhost = $8;
#		sysname = $10$11;
		provider = $13;
		api = $15;
		conn_nb = $17;
		cpu_nb = $19;

		# VR 05/09/94:	curve legend.
		#
		curvename = appli"."conn_nb"."api"."provider;

		# Curve counter.
		# Used later to partition the file in its various .dat files.
		#
		count++;

		# Create the title command of the future curves (throughput
		# and delay).
		#
		printf ("title \"%s %s\" %s \n", count, curvename, style);

		# Save bencht header to identify precisely the future
		# .dat file.
		#
		printf ("%s# %s\n", count, $0);

		# Now reset the cumulative throughput variables.
		#
		cumulT = 0.0;
		nbcumul = 0.0;
	}
	/CLIENT length of msg/ {
		Length = $6;
	}
	/averT/ {
		Throughput=getval($0,"averT");
		cumulT += Throughput;
		nbcumul++;
	}
	/end bench/ {
		# All the connections are now closed and bench has finished.
		# Now print the average throughput/delay of the various
		# connections.
		# The various curves are distinguished by:
		#	iT  -> throughput
		#
		if (nbcumul > 0.0) {
			# Throughput
			cumulT /= nbcumul;
			printf ("%sT %s %f\n",count, Length, cumulT);
		}
		# Sanity check on the trace file.
		#
		if (nbcumul != conn_nb) {
			printf ("gnusort: ERROR, %d conn announced, %d found\n",
				conn_nb, nbcumul);
			exit;
		}
		cumulT = 0.0;
		nbcumul = 0.0;
	}
' > /tmp/sortfile$$


#
# Get the count variable. Saved in the last line of /tmp/sortfile$$
#
count=`awk '/count/ { print $2 }' /tmp/sortfile$$`
if [ "$count" = "0" ]
then
	echo "ERROR: found count==0, probably there is no traces or no header"
	exit -1
fi


#
# Now split the single sortfile in several .dat.T files, one for
# each curve (identified by the begining count number).
#
while true
do
	if [ "$count" = "0" ]
	then
		break
	fi
	#
	# Read the common sortfile$$ file, extract the lines beginning with
	# $countT, remove this number, and save them in a different
	# sortfile$$.dat.T.$count file.
	# 
	cat /tmp/sortfile$$ | grep "^${count}T" 2>/dev/null | sed -e "s/^${count}T//" > /tmp/sortfile$$.dat.T.$count
	count=`expr $count - 1 `
done


#
# Now let do the throughput .dem file
#
echo "set title  \"Throughput Measures\"" > /tmp/sortfile$$.T.dem
echo "set xlabel \"TSDU Length\"" >> /tmp/sortfile$$.T.dem
echo "set ylabel \"kBytes/s\"" >> /tmp/sortfile$$.T.dem
echo "set autoscale" >> /tmp/sortfile$$.T.dem
echo "set nolabel" >> /tmp/sortfile$$.T.dem
echo "set grid" >> /tmp/sortfile$$.T.dem

# Issue the plot command with all the curves.
# VR dec 97: add -n to suppress \n
#
echo -n "plot " >> /tmp/sortfile$$.T.dem
cat /tmp/sortfile$$ | awk '
	BEGIN {
		count = 1
	}
	/^title/ {
		if (count == 1) {
			printf ("\"%s.dat.T.%s\" %s", file, count, $0)
		} else {
			printf (", \"%s.dat.T.%s\" %s", file, count, $0)
		}
		count++
	}
	END {
		printf ("\n")
	}
' file=/tmp/sortfile$$ >> /tmp/sortfile$$.T.dem

echo "pause -1 \"Hit return to continue\"" >>/tmp/sortfile$$.T.dem


# And now, let's see it...
#
xterm -e gnuplot -fn 5x8 /tmp/sortfile$$.T.dem

# rm /tmp/sortfile$$*


