/* $Id: bench.h,v 1.6 1999/03/29 07:36:57 roca Exp $ */
/*
 * bench.h
 *
 *	Modified by : V.Roca
 *	Date	    : dec 1997
 */
/*
 * Copyright (c) 1998/1999 - V.Roca (vincent.roca@lip6.fr) All rights reserved
 * This tool is provided as is, without any warranty.
 * Permission to use, copy and modify is provided for non commercial
 * purposes as long as this notice appears on all copies.
 */


#include <stdio.h>
#include <stdlib.h>
#if defined(SOLARIS) || defined(IRIX)
#include <unistd.h>
#endif /* SOLARIS || IRIX */
#include <math.h>	/* for ceil */
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <ctype.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#if defined(LINUX) || defined(SOLARIS)
#include <sched.h>		/* for real-time sched */
#include <sys/mman.h>		/* for memory pinning */
#endif /* LINUX || SOLARIS */

#include <netinet/in.h>
#include <netinet/tcp.h> 	/* for TCP_NODELAY */
#include <sys/socket.h>
#include <arpa/inet.h>

#ifdef XTI
#include <xti.h>
#include <xti_ns.h>
#include <sys/stropts.h>
#include <sys/poll.h>		/* for poll in RelCon */
#include <sys/xti4.h>		/* for t_opthdr struct */
#endif /*XTI*/
#include <netdb.h>
#ifdef BOSX41
#include <sys/trcfmt.h>		/* for hook definitions */
#endif /* BOSX41 */


#ifdef XTI
	/* Because these symbols are referenced here as <symb>_STR
	   and defined as <symb> in tiuser.h
	*/
#define T_BIND_STR	T_BIND
#define T_OPTMGMT_STR	T_OPTMGMT
#define T_CALL_STR	T_CALL
#define T_DIS_STR     	T_DIS
#define T_UNITDATA_STR 	T_UNITDATA
#define T_UDERROR_STR  	T_UDERROR
#define T_INFO_STR     	T_INFO
#endif	/* XTI */

#if defined(LINUX)
/*
 * On Linux systems, signal handlers must be of __sighandler_t type
 */
#define	sighandler_t	__sighandler_t
#elif defined(SOLARIS) || defined(IRIX) || defined(FREEBSD)
#define	sighandler_t	void (*)(int)
#endif


/****** general constants ******/

/*
 * max length of char strings
 */
#define MAX_NAME_LEN	64

/*
 * max number of connections
 */
#define MAX_CONNECT	2048

/*
 * max and def size of data buffer
 *	MAX_RCVBUF_SIZE:	max recv buffer size
 *	DEF_RCVBUF_SIZE:	default benchd's receive buffer size
 *	MAX_DATA_SIZE:		max size of bench data transmission requests
 *	DEF_DATA_SIZE:		default bench data transmission requests
 */
#define MAX_RCVBUF_SIZE	(64*1024)
#define DEF_RCVBUF_SIZE	MAX_RCVBUF_SIZE
#define MAX_DATA_SIZE	(64*1024)
#define DEF_DATA_SIZE	1024

/*
 * units
 */
#define KILOBYTES_PER_SEC	0
#define KILOBITS_PER_SEC	1
#define MEGABYTES_PER_SEC	2
#define MEGABITS_PER_SEC	3

/*
 * and translation function
 */
#define TRANSL_WITH_UNITS	0
#define TRANSL_WO_UNITS		1
#define TRANSL_ONLY_UNITS	2

/*
 * test mode
 */
#define THRU_MODE		1
#define RTT_MODE		2
#define TT_MODE			3

/*
 * Real-time characteristics.
 */
#if defined(LINUX) || defined(SOLARIS)
#define BENCH_PRI	1		/* */
#define BENCHD_PRI	2		/* receiver prio higher than sender */
#elif defined(BOSX41)
#define BENCH_PRI	PUSER		/* Most favored pri in user range */
#define BENCHD_PRI	PUSER		/* Most favored pri in user range */
#define BENCH_STKSIZ	512*1024	/* Max stack size */
#endif /* BOSX */

/*
 * Format for information passing between bench and benchd
 * on the synchronization TCP connection.
 */
#define SYNC_FORMAT	"SYNC: length %d connect %d"

#ifdef FAST_SYNC
/*
 * Length and content of the start/stop synchronization TCP message  
 * between client and server. This is an alternative method to the
 * use of the synchronization connection.
 */
#define START_STOP_MSG_SIZE	7		/* +1 for the final '\0' */
#define START_MSG		"-START"
#define STOP_MSG		"-STOP-"
#endif /* FAST_SYNC */

/*
 * default time between traces
 */
#define DEF_TIME_TRACE	10

#ifdef SERVER
#define DISCONNECT	-1
#endif

/*
 * socket snd/recv buffer management
 */
#define GET_SOCKBUF	1
#define SET_SOCKBUF	2


/****** general macros ******/

/*
 * print to stdout
 */
#define PRINT_OUT(a) { \
		fprintf a; \
		fflush(stdout); \
	}

/*
 * print to stderr
 */
#define PRINT_ERR(a) { \
		fprintf a; \
		fflush(stderr); \
	}

#define EXIT(c, n) { \
		if (c) \
			kill(getppid(), SIGUSR2); \
		exit(n); \
	}

#define ASSERT(c) { \
		if (!(c)) { \
			fprintf(stderr, "ASSERT [%s:%d] failed\n", \
				__FILE__, __LINE__); \
			fflush(stderr); \
			exit (-1); \
		} \
	}


/****** global variables ******/

/*
 * mode selection variables
 */
extern int verbose;
extern int raw;
extern int sock, xti;
extern int tcp, udp, bcast, mcast;
extern int mode;
extern int eport;
extern int tmsg;
extern int BSD_stack, STREAMS_stack;
extern int rt_pri;
extern int pin;
extern int snd_version;
extern int rcv_version;
extern int duration;
extern int rate;
extern int rate_interval;
extern int pkts_in_burst;
extern int dtonly;
extern int nodelay;
extern int push;
#if defined(MTRACE) && defined(BOSX41)
extern int mtrace;
#endif
extern int syncf;
extern int cpustat;
extern int lockstat;
extern int silent;
extern int units;
#ifdef SERVER
extern int dont_fork;
#endif /* SERVER */


/*
 * statistic variables
 */
extern int connex, conn_fd;
extern int recdata, recmsg;
extern int totdata, totmsg;
#ifdef SERVER
extern float rectt, tottt;
extern int min_recdata, max_recdata, totudploss;
extern float min_tt, max_tt;
#endif /* SERVER */
extern float fthrumin, fthrumax;

/*
 * other variables
 */
extern char servername[], myport[];
extern char provider[];
extern struct timeval time0, time1, time2;
extern struct sockaddr_in sa;
#ifdef XTI
extern struct xtitp tp;
extern struct t_call *call;
extern struct t_unitdata *ud;
#endif /* XTI */

extern char rname[MAX_NAME_LEN];
extern struct in_addr raddr;
extern char *sndbuf;
extern int nbmsg;
extern int lgthmsg;
extern int con;
extern int nbconn;
extern int delay;
extern int recbuf_size;
extern int sock_size;

#ifdef SERVER
extern char recbuf[MAX_RCVBUF_SIZE];	/* change in MAX_DATA_SIZE semantics */
extern int listen_fd;
extern struct sockaddr_in from;
extern int fromlen;
/* extern int dchild; */
#ifdef FAST_SYNC
extern int fast_stop_done;
#endif /* FAST_SYNC */
extern int udp_loss;
#endif /* SERVER */
extern u_short	udp_count;
